// +-----------------------------------------------------------------------+
// |                                                                       |
// | Subroutine for 1D Haar wavelets transform.                            |
// |                                                                       |
// + - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - +
// |                                                                       |
// | Author: Yong-Sheng Chen (yschen@iis.sinica.edu.tw)      10/10/00      |
// |         Institute of Information Science                              |
// |         Academia Sinica, Taipei, Taiwan                               |
// |                                                                       |
// +-----------------------------------------------------------------------+

#include <stdio.h>
#include <math.h>

int maxLevel;        // maximum level number
int *mdim;           // dimension for each level
double *rthresh;     // radius threshold for each level

void transform(double *ps, double *pd)   // 1D Wavelet transform. (Haar basis)
{
   int i, j;
   double *p1, *p2, *s, scale;
 
   scale=1/sqrt(2);
   for ( i=maxLevel; i>0; i-- )
   {
      s  = ps+mdim[i]-2;
      p1 = pd+mdim[i]-1;
      p2 = pd+mdim[i-1]-1;
      for ( j=0; j<mdim[i]; j+=2, s-=2 )
      {
         *p1-- = scale*(*s - *(s+1));
         *p2-- = scale*(*s + *(s+1));
      }
      memcpy(ps, pd, sizeof(double)*mdim[i-1]);
   }
}

void initialize_transformation(int d)
{
   int i;

   for (maxLevel=0, i=1; i<d; maxLevel++)  // check dimension
      i *= 2;
   if (i != d)
   {
      fprintf(stderr, "This program can only deal with 2^n dimension.\n");
      exit(1);
   }
   mdim = (int *)malloc(sizeof(int)*(maxLevel+1));
   rthresh = (double *)malloc(sizeof(double)*(maxLevel+1));
   if (mdim==NULL || rthresh==NULL)
   {
      fprintf(stderr, "initialize_transformation(): malloc error.\n");
      exit(1);
   }
   for (i=1, mdim[0]=1; i<=maxLevel; i++)
      mdim[i] = mdim[i-1]*2;
}

void initialize_rthresh(double rthresh_org)
{
   int i;

   for (i=0; i<=maxLevel; i++)
     rthresh[i]=rthresh_org;
//      rthresh[i]=rthresh_org/sqrt(mdim[i]);
}
