// +-----------------------------------------------------------------------+
// |                                                                       |
// | Subroutine for not any data transform (i.e., original data is used).  |
// |                                                                       |
// + - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - +
// |                                                                       |
// | Author: Yong-Sheng Chen (yschen@iis.sinica.edu.tw)      10/10/00      |
// |         Institute of Information Science                              |
// |         Academia Sinica, Taipei, Taiwan                               |
// |                                                                       |
// +-----------------------------------------------------------------------+

#include <stdio.h>
#include <math.h>

int maxLevel;        // maximum level number
int *mdim;           // dimension for each level
double *rthresh;     // radius threshold for each level

void transform(double *ps, double *pd)   // simply copy the original data point
{
   memcpy(pd, ps, sizeof(double)*mdim[maxLevel]);
}

void initialize_transformation(int d)
{
   int i;

   for (maxLevel=0, i=1; i<d; maxLevel++)  // check dimension
      i *= 2;
   mdim = (int *)malloc(sizeof(int)*(maxLevel+1));
   rthresh = (double *)malloc(sizeof(double)*(maxLevel+1));
   if (mdim==NULL || rthresh==NULL)
   {
      fprintf(stderr, "initialize_transformation(): malloc error.\n");
      exit(1);
   }
   for (i=1, mdim[0]=1; i<=maxLevel; i++)
      mdim[i] = mdim[i-1]*2;
   mdim[maxLevel] = d;  // bottom level may not be a power of 2
}

void initialize_rthresh(double rthresh_org)
{
   int i;
 
   for (i=0; i<=maxLevel; i++)
      rthresh[i]=rthresh_org;
     // rthresh[i]=rthresh_org*sqrt(mdim[i]/mdim[maxLevel]);
}
