// +-----------------------------------------------------------------------+
// |                                                                       |
// | Make the data structure for NN search by using Winner-Update strategy.|
// |                                                                       |
// + - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - +
// |                                                                       |
// | Author: Yong-Sheng Chen (yschen@iis.sinica.edu.tw)      10/14/99      |
// |         Institute of Information Science                              |
// |         Academia Sinica, Taipei, Taiwan                               |
// |                                                                       |
// +-----------------------------------------------------------------------+

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

double *read_points(char *, int *, int *);

int *pindex=NULL;
double *pointsdb;
int *mdim;
int dim, pnum, maxLevel, psize;


static int topcompare(const void *i, const void *j) 
{
   double *pi, *pj;

   pi = pointsdb+(*(int *)i)*psize;
   pj = pointsdb+(*(int *)j)*psize;

   if (*pi > *pj)
      return (1);
   if (*pi < *pj)
      return (-1);
   return (0);
}


void ConstructMultilayer(double *ps, double *pd)
{
   int i, j;
   double *p1, *p2, t1, t2;

   memcpy(pd+dim-1, ps, sizeof(double)*dim);
   for (i=maxLevel; i>0; i--)
   {
      p1 = pd+mdim[i]-1;
      p2 = pd+mdim[i-1]-1;
      for (j=0; j<mdim[i-1]; j++)
      {
         t1 = *p1++;
         t2 = *p1++;
         *p2++ = sqrt(t1*t1+t2*t2);
      }
   }
}


int main(int argc, char *argv[])
{
   int i, tmpv, levelNumber;
   double *points;
   FILE *fp;

   if (argc != 3)
   {
      fprintf(stderr, "Usage: %s sp_fname ssp_fname\n", argv[0]);
      fprintf(stderr, "\t  sp_fname: input file of the sample points\n");
      fprintf(stderr, "\t ssp_fname: output file of the sample point structure\n");
      exit(1);
   }
   points=read_points(argv[1], &dim, &pnum);

   if ( points==NULL)
   {
      fprintf(stderr, "Reading for sample points failed\n");
      exit(1);
   }

   psize = 2*dim-1;

   for (maxLevel=0, tmpv=1; tmpv<dim; maxLevel++)  // check dimension
      tmpv *= 2;
   if (tmpv != dim)
   {
      fprintf(stderr, "This program can only deal with 2^n dimension.\n");
      exit(1);
   }
   levelNumber = maxLevel+1;

   mdim = (int *)malloc(sizeof(int)*levelNumber);
   pindex = (int *)malloc(sizeof(int)*pnum);
   pointsdb = (double *)malloc(sizeof(double)*pnum*psize);

   if ( mdim==NULL || pindex==NULL || pointsdb==NULL )
   {
      fprintf(stderr, "malloc error.\n");
      exit(1);
   }

   for (i=1, mdim[0]=1; i<levelNumber; i++)
      mdim[i] = mdim[i-1]*2;

   for (i=0; i<pnum; i++)
   {
      pindex[i]=i;
      ConstructMultilayer(points+i*dim, pointsdb+i*psize);
   }
   qsort((char *)pindex, pnum, sizeof(int), topcompare);

   fp = fopen(argv[2], "wb");
   if (fp==NULL)
   {
      fprintf(stderr, "File %s open error!\n", argv[2]);
      exit(1);
   }
   fwrite(&dim, sizeof(int), 1, fp);
   fwrite(&pnum, sizeof(int), 1, fp);
   fwrite(pindex, sizeof(int), pnum, fp);
   fwrite(pointsdb, sizeof(double), pnum*psize, fp);
   fclose(fp);
}
