// +-----------------------------------------------------------------------+
// |                                                                       |
// | This subroutine read data points with given filename.                 |
// |                                                                       |
// + - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - +
// |                                                                       |
// | Author: Yong-Sheng Chen (yschen@iis.sinica.edu.tw)      10/14/99      |
// |         Institute of Information Science                              |
// |         Academia Sinica, Taipei, Taiwan                               |
// |                                                                       |
// +-----------------------------------------------------------------------+

#include <stdio.h>
#include <stdlib.h>


double *read_points(char *fname, int *dim, int *pnum)
{
   FILE *fp;
   double *points;
   char msg[80];
   int amount;

   fp = fopen(fname, "rb");
   if (fp==NULL)
   {
      fprintf(stderr, "read_points(): file %s open error!\n", fname);
      return NULL;
   }

   fscanf(fp, "%s %d %d\n", msg, dim, pnum);

   amount = *dim * *pnum;
   points=(double *)malloc(sizeof(double)*amount);
   if (points==NULL)
   {
      fprintf(stderr, "read_points(): memory allocation error!\n");
      return NULL;
   }

   fread(points, sizeof(double), amount, fp);

   fclose(fp);

   return (points);
}
