// +-----------------------------------------------------------------------+
// |                                                                       |
// | Main subroutine for all the nearest neighbor search program. It reads |
// | a data set of query points and call subroutine to perform the search. |
// | Mean query time is reported.                                          |
// |                                                                       |
// + - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - +
// |                                                                       |
// | Author: Yong-Sheng Chen (yschen@iis.sinica.edu.tw)      10/10/00      |
// |         Institute of Information Science                              |
// |         Academia Sinica, Taipei, Taiwan                               |
// |                                                                       |
// +-----------------------------------------------------------------------+

#include <stdio.h>
#include <stdlib.h>
#include <sys/timeb.h>


int read_structure(char *);
double *read_points(char *, int *, int *);
int inquire(double *, int *, double *);


int main(int argc, char *argv[])
{
   int qdim, qnum, index, i;
   double *query, dist, tdist=0.0;
   struct timeb ts, tp;
   double elapse_time;


   if (argc != 3)
   {
      fprintf(stderr, "Usage: %s ssp_fname qp_fname\n", argv[0]);
      fprintf(stderr, "\t ssp_fname: input file of the sample point tree structure\n");
      fprintf(stderr, "\t  qp_fname: input file of the query point set\n");
      exit(1);
   }

   // read data structure of sample points according to search algorithm
   if ( read_structure(argv[1])==0 )
   {
      fprintf(stderr, "Structure reading for sample points failed\n");
      exit(1);
   }

   // read data set of query points
   query= read_points(argv[2], &qdim, &qnum);
   if ( query==NULL)
   {
      fprintf(stderr, "Reading for query points failed\n");
      exit(1);
   }

   system("date");
   ftime(&ts);

   for (i=0; i<qnum; i++)
   {
      inquire(query+i*qdim, &index, &dist); // perform NN search
      tdist+=dist;
//      fprintf(stdout, "QueryPoint (%d): NN SamplePoint %d, distance: %f\n", i, index, dist);
   }

   ftime(&tp);
   system("date");

   elapse_time = (double) tp.time*1000 + (double) tp.millitm -
                 (double) ts.time*1000 - (double) ts.millitm;
   printf("Mean query time: %f ms\n", elapse_time/qnum);
   printf("Mean closest distance: %f\n", tdist/qnum);
}
