// +-----------------------------------------------------------------------+
// |                                                                       |
// | Nearest neighbor search by using exhaustive search algorithm.         |
// |                                                                       |
// + - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - +
// |                                                                       |
// | Author: Yong-Sheng Chen (yschen@iis.sinica.edu.tw)      10/10/00      |
// |         Institute of Information Science                              |
// |         Academia Sinica, Taipei, Taiwan                               |
// |                                                                       |
// +-----------------------------------------------------------------------+

#include <stdio.h>
#include <stdlib.h>
#include <math.h>


double *read_points(char *, int *, int *);
double *pointsdb;
int dim, pnum;


// Read the data set of the sample points
int read_structure(char *fname)
{
   pointsdb=read_points(fname, &dim, &pnum);
   if ( pointsdb==NULL)
   {
      fprintf(stderr, "Reading for sample points failed\n");
      return 0;
   }
   else
      return(pnum);
}


// perform the NN search by using exhaustive search algorithm
void inquire(double *point, int *index, double *dist)
{
   int d, i, minindex;
   double mindist, tdist;
   double *p, tmp;

   // Assume the first sample point is closest and calculate the distance
   minindex = 0;
   for (d=0, mindist=0.0; d<dim; d++)
   {
      tmp = point[d]-pointsdb[d];
      mindist += tmp*tmp;
   }

   // Calculate the distance to the other sample points and update the
   // minimum distance when necessary
   for (i=1; i<pnum; i++)
   {
      tdist=0;
      p = pointsdb + i*dim;
      for (d=0; d<dim; d++)
      {
         tmp = point[d]-p[d];
         tdist += tmp*tmp;
      }
      if (tdist < mindist)
      {
	 minindex = i;
	 mindist = tdist;
      }
   }
   *index = minindex;
   *dist =  sqrt(mindist);
}
