// +-----------------------------------------------------------------------+
// |                                                                       |
// | This program generates a set of query points by adding uniformally    |
// | distributed noise to each coordinate for each sample point.           |
// |                                                                       |
// + - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - +
// |                                                                       |
// | Author: Yong-Sheng Chen (yschen@iis.sinica.edu.tw)      10/14/99      |
// |         Institute of Information Science                              |
// |         Academia Sinica, Taipei, Taiwan                               |
// |                                                                       |
// +-----------------------------------------------------------------------+

#include <stdio.h>
#include <stdlib.h>
#include <values.h>
#include <sys/timeb.h>


double *read_points(char *, int *, int *);


// Set the seed for the uniform distribution random number generator
void my_srand()
{
   struct timeb timeseed;   // seed for random number generator

   ftime(&timeseed);
   srandom(timeseed.millitm);
}


// Generate uniformly distributed random number over [-1, 1]
double my_drand()
{
   double d;

   d=(double)random()/RAND_MAX;       // d: [0.0, 1.0]
   return 2.0*(d-0.5);
}


int main(int argc, char *argv[])
{
   FILE *fp;
   int dim, pnum, p, d;
   double *points, *point, ext;


   if (argc != 4)
   {
      fprintf(stderr, "Usage: %s sp_fname qp_fname e\n", argv[0]);
      fprintf(stderr, "\t sp_fname: input file of the sample points\n");
      fprintf(stderr, "\t qp_fname: output file of the generated query points\n");
      fprintf(stderr, "\t        e: extent of the noise to be added ([-e,e])\n");
      exit(1);
   }

   points=read_points(argv[1], &dim, &pnum);
   if ( points==NULL)
   {
      fprintf(stderr, "Reading for sample points failed\n");
      exit(1);
   }

   fp    =fopen(argv[2],"wb");
   ext   =atof(argv[3]);

   fprintf(fp, "POINTS %d %d\n",dim,pnum);
   fprintf(stdout, "Generating %d random query points with %d dimension...\n",
                   pnum, dim);

   point = (double *)malloc(sizeof(double)*dim);

   my_srand();
   
   for (p=0; p<pnum; p++)
   {
      point=points+p*dim;
      for (d=0; d<dim; d++)
         point[d] += ext*my_drand();
      fwrite(point, sizeof(double), dim, fp);
   }

   fprintf(stdout, "Done.\n\n");

   fclose(fp);
}
