
program Lagrange { N.B. Brute force program; CPU is fast enough } ;

type LF = function(const L, M : extended) : extended ;
{ See http://www.merlyn.demon.co.uk/gravity0.htm for derivations. }


function LF1(const L, M : extended) : extended ; FAR ;
begin LF1 :=
    M*L*L*L*L*L - 3*M*L*L*L*L + 3*M*L*L*L -       L*L +   2*L - 1 end {LF1} ;

function LF2(const L, M : extended) : extended ; FAR ;
begin LF2 :=
    M*L*L*L*L*L + 3*M*L*L*L*L + 3*M*L*L*L -       L*L -   2*L - 1 end {LF2} ;

function LF3(const L, M : extended) : extended ; FAR ;
begin LF3 :=
    M*L*L*L*L*L + 2*M*L*L*L*L +   M*L*L*L - (M+1)*L*L - 2*M*L - M end {LF3} ;


var Earth, Moon, R, M, c, w : extended ;

function LFc1(const L, M : extended) : extended ; FAR ;
begin LFc1 := -w*(R-c-L) + M/Sqr(R-L) - 1/Sqr(L) end {LFc1} ;

function LFc2(const L, M : extended) : extended ; FAR ;
{ Corrected, 2005-04-28 }
begin LFc2 := -w*(R-c+L) + M/Sqr(R+L) + 1/Sqr(L) end {LFc2} ;

function LFc3(const L, M : extended) : extended ; FAR ;
begin LFc3 := -w*(L+c)   + M/Sqr(L)   + 1/Sqr(R+L) end {LFc3} ;


type LH = (L, H) ;
Drec = record LFs : LF ; Ini : array [LH] of extended ; B : boolean end ;
const Data1 : array [1..3] of Drec = (
  (LFs:LF1; Ini:(1E-6, 0.5); B:false),
  (LFs:LF2; Ini:(1E-6, 1.0); B:false),
  (LFs:LF3; Ini:(1E-6, 2.0); B:false) ) ;
const Data2 : array [1..3] of Drec = (
  (LFs:LFc1; Ini:(1E-6, 0.5); B:true),
  (LFs:LFc2; Ini:(1E-6, 1.0); B:true),
  (LFs:LFc3; Ini:(1E-6, 2.0); B:true) ) ;


procedure Iter(DR : Drec) { simple, adequate, but inefficient } ;
var X, Y, Z, Mid, Ans : extended ; K : byte ;
begin with DR do begin
    if B then begin Ini[L] := Ini[L]*R ; Ini[H] := Ini[H]*R end ;
    Write(Ini[L]:6:3, Ini[H]:6:3, ' : ') ;
    K := 1 ;
    repeat Mid := (Ini[H]+Ini[L])*0.5 ;
      X := LFs(Ini[H], M) ;
      Y := LFs(Mid   , M) ;
      Z := LFs(Ini[L], M) ;
      if Abs(X-Z)/M<1E-20 then BREAK ;
      if Y=0.0 then BREAK ;
      if X*Z>=0 then begin Write(' Bad bounds.') ; Readln ; HALT(222) end ;
      if X*Y>0.0 then Ini[H] := Mid else Ini[L] := Mid ;
      Inc(K) until K=$FF ;
    if B then Ans := Mid else Ans := Mid*R ;
    Writeln(K:4, Mid:10:6, Y:10:6, Ans:20:6) ;
    end end {Iter} ;

var J : byte ;

begin Writeln('LAGRANGE.PAS  www.merlyn.demon.co.uk  >=2005-04-28',
    238857*1.609:15:0, ' km.') ;
  Write(' Major mass, Minor mass, Separation ??? ') ;
  Readln(Earth, Moon, R) ;
  M := Earth/Moon ;
  Writeln(' For M/m >> 1, taking major mass as centre of motion :') ;
  for J := 1 to 3 do begin Write('  Iterate L', J) ; Iter(Data1[J]) end ;
  c := R/(M+1) ;
  Writeln(' Using CofG as centre of motion - c = ', c:0:6, ' :') ;
  w := M/(Sqr(R)*(R-c)) ;
  for J := 1 to 3 do begin Write('  Iterate L', J) ; Iter(Data2[J]) end ;
  Write('<cr>') ; Readln end.
