//tstList.cpp -- by tsaiwn@csie.nctu.edu.tw
#include "list"
//use it if there is a file named "list" in current directory
//otherwise will use the C++ STL include file  <list>
#include <iostream>
using namespace std;
template<class T> void print(list<T> &a) {  // print list<T>
   typename list<T>::iterator it;  // do NOT forget "typename"
   for( it=a.begin( ); it!= a.end( ); ++it) cout << " "<< *it;
   cout << endl;
}
template<class T> void prHeadTail(list<T> a) {
   typename list<T>::iterator hh = a.begin( );  // front
   typename list<T>::iterator tail = a.end( );   // behind last
   --tail;   // move back to point to the last element
   //typename is required in template to tell compiler that ...
   cout << " size = " << a.size( )<< ", ";
    // Note that there is no capacity( ) for list
   cout << " Head=" << *hh<<", " << " Tail=" << *tail;  
   cout << "; front=" << a.front( )<<", back="<<a.back( )<<endl;
}// prHeadTail
int main( ) {
   list<int> gg;      // should use list<Integer> in Java
   list<double> yy;    // should use list<Double> in Java
   cout << "Initial gg: "; prHeadTail(gg);
   cout << "Initial yy: "; prHeadTail(yy);
   gg.push_back(123);
   gg.push_back(456); gg.push_back(38);
   gg.push_front(888); gg.push_front(58);
   cout << "Original list gg: ";    // gg.front( ) = 168;
   print(gg);  
   prHeadTail(gg);  
   gg.sort( );
   cout << "After sort, gg: "; print(gg);  prHeadTail(gg);
   yy.push_back(12.5); yy.push_back(3.8); yy.push_back(4.9);
   cout << "after yy.push_back( )  yy: "; 
   print(yy); prHeadTail(yy);
   return 0;
}// main(        //  see   http://www.cplusplus.com
/******   First, test my "list"   <======== in current directory
C:\testc\STL>dir list
2010/05/29  U 11:58             2,600 list
...
C:\testc\STL>g++ tstList.cpp
C:\testc\STL>a
Initial gg:  size = 0,  Head=0,  Tail=0; front=0, back=0
Initial yy:  size = 0,  Head=0,  Tail=0; front=0, back=0
Original list gg:  58 888 123 456 38
 size = 5,  Head=58,  Tail=38; front=58, back=38
After sort, gg:  58 888 123 456 38
 size = 5,  Head=58,  Tail=38; front=58, back=38
after yy.push_back( )  yy:  12.5 3.8 4.9
 size = 3,  Head=12.5,  Tail=4.9; front=12.5, back=4.9

//////=== now force to use C++ STL <list>  because rename list
C:\testc\STL>ren list listME
C:\testc\STL>g++ tstList.cpp
C:\testc\STL>a
Initial gg:  size = 0,  Head=8,  Tail=8; front=8, back=8
Initial yy:  size = 0,  Head=5.28441e-308,  Tail=5.28441e-308; 
    front=5.28441e-308, back=5.28441e-308
Original list gg:  58 888 123 456 38
 size = 5,  Head=58,  Tail=38; front=58, back=38
After sort, gg:  38 58 123 456 888
 size = 5,  Head=38,  Tail=888; front=38, back=888
after yy.push_back( )  yy:  12.5 3.8 4.9
 size = 3,  Head=12.5,  Tail=4.9; front=12.5, back=4.9
********************************************/
