//sortVec.cpp  --- @CopyLeft by tsaiwn@csie.nctu.edu.tw
//Demo using sort in <algorithm> to sort a vector
// C++ STL sort( ) is NOT stable (quick sort);  t stable_sort( )
#include <iostream>
#include <vector>
#include <algorithm>
#include <string>
#include <string.h>
#include <cctype>
using namespace std;

// function to do comparison, not case sensitive.
bool compare_nocase (string first, string second) {
  unsigned int i=0;
  while ( (i<first.length()) && (i<second.length()) ) {
    if (tolower(first[i])<tolower(second[i])) return true;
    else if (tolower(first[i])>tolower(second[i])) return false;
    ++i;
  }
  if (first.length()<second.length()) return true;
  else return false;
} // compare_nocase (

bool mycomp(string x, string y) {  cout << " haha ";
   return strcmp(y.c_str( ), x.c_str( ) ) < 0;
}
/****** STL vector can be used like an array in C++ ******/
void printVector(vector<string> x) {  //you can try x.at(i)
   for(int i=0; i< x.size( ); ++i)  cout << " " << x[i];
   cout << endl;
}
///////////////////
int main ( ) {
  vector<string> xx;
  xx.push_back("aaa"); xx.push_back("ccc");  xx.push_back("bbb");
  xx.push_back("BBS"); xx.push_back("egg"); xx.push_back("EGG_BIG");
  cout << "vector xx: ";  printVector(xx);
  sort(xx.begin( ), xx.end( ) );    // ascending by default
  cout << "\n=== after sort\n  vector xx: ";   printVector(xx);

  cout << "\n=== now calling sort with mycomp.. ";
  sort(xx.begin( ), xx.end( ) , mycomp);    
  cout << "\n=== after sort(..., mycomp)\n  vector xx: ";
  printVector(xx);

  sort(xx.begin( ), xx.end( ) , compare_nocase);    
  cout << "\n=== after sort(..., compare_nocase)\n  vector xx: ";
  printVector(xx);
  return 0;
} // main(
/******
C:\testc\STL>g++ sortVec.cpp

C:\testc\STL>a
vector xx:  aaa ccc bbb BBS egg EGG_BIG

=== after sort
  vector xx:  BBS EGG_BIG aaa bbb ccc egg

=== now calling sort with mycomp..  haha  haha  haha  haha  haha
=== after sort(..., mycomp)
  vector xx:  egg ccc bbb aaa EGG_BIG BBS

=== after sort(..., compare_nocase)
  vector xx:  aaa bbb BBS ccc egg EGG_BIG
*******************************/
