//sortList.cpp  --- demo using list::sort
//from http://www.cplusplus.com/reference/stl/list/sort.html
// modified by tsaiwn@csie.nctu.edu.tw
#include <iostream>
#include <list>
#include <string>
#include <cctype>
using namespace std;

// comparison, not case sensitive.
bool compare_nocase (string first, string second)
{
  unsigned int i=0;
  while ( (i<first.length()) && (i<second.length()) )
  {
    if (tolower(first[i])<tolower(second[i])) return true;
    else if (tolower(first[i])>tolower(second[i])) return false;
    ++i;
  }
  if (first.length()<second.length()) return true;
  else return false;
}
void printList(list<string>);
int main ( )
{
  list<string> aList;

  aList.push_back ("one");  aList.push_back ("two");
  aList.push_back ("Three");
  aList.push_back("Four"); aList.push_back("five");
  aList.push_front("ZERO_haha"); aList.push_back("six");

  cout << "mylist contains:"; printList(aList);

  aList.sort();
  cout << "After sort( ),\nmylist contains:";
  printList(aList);

  aList.sort(compare_nocase);
  cout << "After sort(compare_nocase),\nmylist contains:";
  printList(aList);

  return 0;
}
// use an iterator to traverse a Linked List
void printList(list<string> myList) {
  list<string>::iterator it;
  for (it=myList.begin( ); it != myList.end( ); ++it)
     cout << " " << *it;   // iterator is actually a pointer
  cout << endl;
}
/******
C:\testc>g++ sortList.cpp

C:\testc>a.exe
mylist contains: ZERO_haha one two Three Four five six
After sort( ),
mylist contains: Four Three ZERO_haha five one six two
After sort(compare_nocase),
mylist contains: five Four one six Three two ZERO_haha

C:\testc>                   *******************************/

