//MidiPlayer.java  -- @CopyLeft by tsaiwn@cs.nctu.edu.tw
import java.io.*;
import javax.sound.midi.*;
import java.net.*;
import java.awt.*;
import java.applet.*;
///////
class MidiPlayer extends Applet {
    //public void play(String filename);
    //public void play(String filename, boolean loop);
    //public  void stop( );

    protected Sequencer sequencer = null; 
    public  Sequencer getSequencer( ) { return sequencer; }
       
    public void play(String filename) { play(filename, false); }
    public void play(String filename, boolean loop) {
        try {
            stop( );
            sequencer = MidiSystem.getSequencer();

            URL url = null;

            try {
                Toolkit tkt = Toolkit.getDefaultToolkit( );
                Class me = getClass( );   // get The class is running
                url = me.getResource(filename); // for Application ?
            } catch ( Exception e) {;}
            if(url == null) {
                System.out.println(" Try getCodeBase( ) way ...");
                try {  // try again
                   URL codeBase = getCodeBase( );
                   url = new URL( codeBase + filename );
                   //url = new URL("file:" + System.getProperty("user.dir") + "/");
                } catch ( Exception e ) {; }
            } // if(url

            sequencer.setSequence(MidiSystem.getSequence( url ));

            if (loop)
                sequencer.setLoopCount(Sequencer.LOOP_CONTINUOUSLY);
            sequencer.open( );
            sequencer.start( );
         } catch (Exception e) {
             System.err.println("MidiPlayer: " + e);
             sequencer = null;
         }
    } //play(

    public  void stop( ) {
        try {
            if ((sequencer == null) || (!sequencer.isRunning())) return;
            sequencer.stop( );
            sequencer.close( );
        }
        catch (Exception e) {
             System.err.println("MidiPlayer: " + e);
        }
        sequencer = null;
    } //stop(

} // class MidiPlayer
