/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkPropertiesDialog;

public class AddBookmarkAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.AddBookmarkAction";
    private IShellProvider shellProvider;
    private boolean promptForName = true;
    static /* synthetic */ Class class$0;

    public AddBookmarkAction(Shell shell) {
        this(shell, true);
    }

    public AddBookmarkAction(final Shell shell, boolean promptForName) {
        super(IDEWorkbenchMessages.AddBookmarkLabel);
        Assert.isNotNull((Object)shell);
        this.shellProvider = new IShellProvider(){

            public Shell getShell() {
                return shell;
            }
        };
        this.initAction(promptForName);
    }

    public AddBookmarkAction(IShellProvider provider, boolean promptForName) {
        super(IDEWorkbenchMessages.AddBookmarkLabel);
        Assert.isNotNull((Object)provider);
        this.shellProvider = provider;
        this.initAction(promptForName);
    }

    private void initAction(boolean promptForName) {
        this.promptForName = promptForName;
        this.setToolTipText(IDEWorkbenchMessages.AddBookmarkToolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.add_bookmark_action_context");
        this.setId(ID);
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            IFile file = null;
            if (o instanceof IFile) {
                file = (IFile)o;
            } else if (o instanceof IAdaptable) {
                Object resource;
                IAdaptable iAdaptable = (IAdaptable)o;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = iAdaptable.getAdapter((Class)clazz)) instanceof IFile) {
                    file = (IFile)resource;
                }
            }
            if (file == null) continue;
            if (this.promptForName) {
                BookmarkPropertiesDialog dialog = new BookmarkPropertiesDialog(this.shellProvider.getShell());
                dialog.setResource((IResource)file);
                dialog.open();
                continue;
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("message", file.getName());
            CreateMarkersOperation op = new CreateMarkersOperation("org.eclipse.core.resources.bookmark", attrs, (IResource)file, BookmarkMessages.CreateBookmark_undoText);
            try {
                PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, null, WorkspaceUndoUtil.getUIInfoAdapter(this.shellProvider.getShell()));
            }
            catch (ExecutionException e) {
                IDEWorkbenchPlugin.log(null, e);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && !selection.isEmpty() && this.selectionIsOfType(1);
    }
}

