/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetConfigurationDialog;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class ConfigureWorkingSetAction
extends Action {
    private final IWorkbenchPartSite fSite;
    private WorkingSetModel fWorkingSetModel;

    public ConfigureWorkingSetAction(IWorkbenchPartSite site) {
        super(WorkingSetMessages.ConfigureWorkingSetAction_label);
        this.fSite = site;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.configure_working_sets_action_context");
    }

    public void setWorkingSetModel(WorkingSetModel model) {
        this.fWorkingSetModel = model;
    }

    public void run() {
        ArrayList<IWorkingSet> workingSets = new ArrayList<IWorkingSet>(Arrays.asList(this.fWorkingSetModel.getAllWorkingSets()));
        IWorkingSet[] activeWorkingSets = this.fWorkingSetModel.needsConfiguration() ? this.fWorkingSetModel.getAllWorkingSets() : this.fWorkingSetModel.getActiveWorkingSets();
        boolean isSortingEnabled = this.fWorkingSetModel.isSortingEnabled();
        WorkingSetConfigurationDialog dialog = new WorkingSetConfigurationDialog(this.fSite.getShell(), workingSets.toArray(new IWorkingSet[workingSets.size()]), isSortingEnabled);
        dialog.setSelection(activeWorkingSets);
        if (dialog.open() == 0) {
            isSortingEnabled = dialog.isSortingEnabled();
            IWorkingSet[] selection = dialog.getSelection();
            this.fWorkingSetModel.setActiveWorkingSets(selection, isSortingEnabled);
        }
    }
}

