/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionElement;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.WizardNode;
import org.eclipse.pde.internal.ui.wizards.WizardTreeSelectionPage;
import org.eclipse.pde.internal.ui.wizards.templates.NewExtensionTemplateWizard;
import org.eclipse.pde.ui.IBasePluginWizard;
import org.eclipse.pde.ui.IExtensionWizard;
import org.eclipse.pde.ui.templates.ITemplateSection;

public class ExtensionTreeSelectionPage
extends WizardTreeSelectionPage {
    private IProject fProject;
    private IPluginBase fPluginBase;

    public ExtensionTreeSelectionPage(WizardCollectionElement categories, String baseCategory, String message) {
        super(categories, baseCategory, message);
    }

    public void init(IProject project, IPluginBase pluginBase) {
        this.fProject = project;
        this.fPluginBase = pluginBase;
    }

    protected IWizardNode createWizardNode(WizardElement element) {
        return new WizardNode(this, element){

            public IBasePluginWizard createWizard() throws CoreException {
                IExtensionWizard wizard = this.createWizard(this.wizardElement);
                wizard.init(ExtensionTreeSelectionPage.this.fProject, ExtensionTreeSelectionPage.this.fPluginBase.getPluginModel());
                return wizard;
            }

            protected IExtensionWizard createWizard(WizardElement element) throws CoreException {
                if (element.isTemplate()) {
                    IConfigurationElement template = element.getTemplateElement();
                    if (template == null) {
                        return null;
                    }
                    ITemplateSection section = (ITemplateSection)template.createExecutableExtension("class");
                    return new NewExtensionTemplateWizard(section);
                }
                return (IExtensionWizard)element.createExecutableExtension();
            }
        };
    }

    public ISelectionProvider getSelectionProvider() {
        return this.wizardSelectionViewer;
    }
}

