/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.retrieve;

import java.net.MalformedURLException;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferNamespace;
import org.eclipse.ecf.provider.filetransfer.retrieve.UrlConnectionRetrieveFileTransfer;

public class MultiProtocolRetrieveAdapter
implements IRetrieveFileTransfer {
    IConnectContext connectContext = null;
    Proxy proxy = null;

    public Namespace getRetrieveNamespace() {
        return IDFactory.getDefault().getNamespaceByName(FileTransferNamespace.PROTOCOL);
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        this.connectContext = connectContext;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void sendRetrieveRequest(IFileID remoteFileID, IFileTransferListener transferListener, Map options) throws IncomingFileTransferException {
        String protocol = null;
        try {
            protocol = remoteFileID.getURL().getProtocol();
        }
        catch (MalformedURLException e) {
            throw new IncomingFileTransferException(Messages.AbstractRetrieveFileTransfer_MalformedURLException);
        }
        IRetrieveFileTransfer fileTransfer = null;
        fileTransfer = Activator.getDefault().getFileTransfer(protocol);
        if (fileTransfer == null) {
            fileTransfer = new UrlConnectionRetrieveFileTransfer();
        }
        fileTransfer.setConnectContextForAuthentication(this.connectContext);
        fileTransfer.setProxy(this.proxy);
        fileTransfer.sendRetrieveRequest(remoteFileID, transferListener, options);
    }

    public void sendRetrieveRequest(IFileID remoteFileID, IFileRangeSpecification rangeSpecification, IFileTransferListener transferListener, Map options) throws IncomingFileTransferException {
        String protocol = null;
        try {
            protocol = remoteFileID.getURL().getProtocol();
        }
        catch (MalformedURLException e) {
            throw new IncomingFileTransferException(Messages.AbstractRetrieveFileTransfer_MalformedURLException);
        }
        IRetrieveFileTransfer fileTransfer = null;
        fileTransfer = Activator.getDefault().getFileTransfer(protocol);
        if (fileTransfer == null) {
            fileTransfer = new UrlConnectionRetrieveFileTransfer();
        }
        fileTransfer.setConnectContextForAuthentication(this.connectContext);
        fileTransfer.setProxy(this.proxy);
        fileTransfer.sendRetrieveRequest(remoteFileID, rangeSpecification, transferListener, options);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        IAdapterManager adapterManager = Activator.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return adapterManager.loadAdapter((Object)this, adapter.getName());
    }
}

