/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.text.MaskFormatter;

public class TextInputDemo
extends JPanel
implements ActionListener,
FocusListener {
    JTextField streetField;
    JTextField cityField;
    JFormattedTextField zipField;
    JSpinner stateSpinner;
    boolean addressSet = false;
    Font regularFont;
    Font italicFont;
    JLabel addressDisplay;
    static final int GAP = 10;

    public TextInputDemo() {
        this.setLayout(new BoxLayout(this, 2));
        JPanel jPanel = new JPanel(){

            public Dimension getMaximumSize() {
                Dimension dimension = this.getPreferredSize();
                return new Dimension(Integer.MAX_VALUE, dimension.height);
            }
        };
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(this.createEntryFields());
        jPanel.add(this.createButtons());
        this.add(jPanel);
        this.add(this.createAddressDisplay());
    }

    protected JComponent createButtons() {
        JPanel jPanel = new JPanel(new FlowLayout(4));
        JButton jButton = new JButton("Set address");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        jButton = new JButton("Clear address");
        jButton.addActionListener(this);
        jButton.setActionCommand("clear");
        jPanel.add(jButton);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("clear".equals(actionEvent.getActionCommand())) {
            this.addressSet = false;
            this.streetField.setText("");
            this.cityField.setText("");
            this.zipField.setValue(null);
        } else {
            this.addressSet = true;
        }
        this.updateDisplays();
    }

    protected void updateDisplays() {
        this.addressDisplay.setText(this.formatAddress());
        if (this.addressSet) {
            this.addressDisplay.setFont(this.regularFont);
        } else {
            this.addressDisplay.setFont(this.italicFont);
        }
    }

    protected JComponent createAddressDisplay() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.addressDisplay = new JLabel();
        this.addressDisplay.setHorizontalAlignment(0);
        this.regularFont = this.addressDisplay.getFont().deriveFont(0, 16.0f);
        this.italicFont = this.regularFont.deriveFont(2);
        this.updateDisplays();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        jPanel.add((Component)new JSeparator(1), "Before");
        jPanel.add((Component)this.addressDisplay, "Center");
        jPanel.setPreferredSize(new Dimension(200, 150));
        return jPanel;
    }

    protected String formatAddress() {
        if (!this.addressSet) {
            return "No address set.";
        }
        String string = this.streetField.getText();
        String string2 = this.cityField.getText();
        String string3 = (String)this.stateSpinner.getValue();
        String string4 = this.zipField.getText();
        String string5 = "";
        if (string == null || string5.equals(string)) {
            string = "<em>(no street specified)</em>";
        }
        if (string2 == null || string5.equals(string2)) {
            string2 = "<em>(no city specified)</em>";
        }
        if (string3 == null || string5.equals(string3)) {
            string3 = "<em>(no state specified)</em>";
        } else {
            int n = string3.indexOf(40) + 1;
            string3 = string3.substring(n, n + 2);
        }
        if (string4 == null || string5.equals(string4)) {
            string4 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><p align=center>");
        stringBuffer.append(string);
        stringBuffer.append("<br>");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(string3);
        stringBuffer.append(" ");
        stringBuffer.append(string4);
        stringBuffer.append("</p></html>");
        return stringBuffer.toString();
    }

    protected MaskFormatter createFormatter(String string) {
        MaskFormatter maskFormatter = null;
        try {
            maskFormatter = new MaskFormatter(string);
        }
        catch (ParseException parseException) {
            System.err.println("formatter is bad: " + parseException.getMessage());
            System.exit(-1);
        }
        return maskFormatter;
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof JFormattedTextField) {
            this.selectItLater(component);
        } else if (component instanceof JTextField) {
            ((JTextField)component).selectAll();
        }
    }

    protected void selectItLater(Component component) {
        if (component instanceof JFormattedTextField) {
            final JFormattedTextField jFormattedTextField = (JFormattedTextField)component;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jFormattedTextField.selectAll();
                }
            });
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    protected JComponent createEntryFields() {
        JPanel jPanel = new JPanel(new SpringLayout());
        String[] stringArray = new String[]{"Street address: ", "City: ", "State: ", "Zip code: "};
        JLabel[] jLabelArray = new JLabel[stringArray.length];
        JComponent[] jComponentArray = new JComponent[stringArray.length];
        int n = 0;
        this.streetField = new JTextField();
        this.streetField.setColumns(20);
        jComponentArray[n++] = this.streetField;
        this.cityField = new JTextField();
        this.cityField.setColumns(20);
        jComponentArray[n++] = this.cityField;
        Object[] objectArray = this.getStateStrings();
        this.stateSpinner = new JSpinner(new SpinnerListModel(objectArray));
        jComponentArray[n++] = this.stateSpinner;
        this.zipField = new JFormattedTextField(this.createFormatter("#####"));
        jComponentArray[n++] = this.zipField;
        for (int i = 0; i < stringArray.length; ++i) {
            jLabelArray[i] = new JLabel(stringArray[i], 11);
            jLabelArray[i].setLabelFor(jComponentArray[i]);
            jPanel.add(jLabelArray[i]);
            jPanel.add(jComponentArray[i]);
            JTextField jTextField = null;
            jTextField = jComponentArray[i] instanceof JSpinner ? this.getTextField((JSpinner)jComponentArray[i]) : (JTextField)jComponentArray[i];
            jTextField.addActionListener(this);
            jTextField.addFocusListener(this);
        }
        SpringUtilities.makeCompactGrid(jPanel, stringArray.length, 2, 10, 10, 10, 5);
        return jPanel;
    }

    public String[] getStateStrings() {
        String[] stringArray = new String[]{"Alabama (AL)", "Alaska (AK)", "Arizona (AZ)", "Arkansas (AR)", "California (CA)", "Colorado (CO)", "Connecticut (CT)", "Delaware (DE)", "District of Columbia (DC)", "Florida (FL)", "Georgia (GA)", "Hawaii (HI)", "Idaho (ID)", "Illinois (IL)", "Indiana (IN)", "Iowa (IA)", "Kansas (KS)", "Kentucky (KY)", "Louisiana (LA)", "Maine (ME)", "Maryland (MD)", "Massachusetts (MA)", "Michigan (MI)", "Minnesota (MN)", "Mississippi (MS)", "Missouri (MO)", "Montana (MT)", "Nebraska (NE)", "Nevada (NV)", "New Hampshire (NH)", "New Jersey (NJ)", "New Mexico (NM)", "New York (NY)", "North Carolina (NC)", "North Dakota (ND)", "Ohio (OH)", "Oklahoma (OK)", "Oregon (OR)", "Pennsylvania (PA)", "Rhode Island (RI)", "South Carolina (SC)", "South Dakota (SD)", "Tennessee (TN)", "Texas (TX)", "Utah (UT)", "Vermont (VT)", "Virginia (VA)", "Washington (WA)", "West Virginia (WV)", "Wisconsin (WI)", "Wyoming (WY)"};
        return stringArray;
    }

    public JFormattedTextField getTextField(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        System.err.println("Unexpected editor type: " + jSpinner.getEditor().getClass() + " isn't a descendant of DefaultEditor");
        return null;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("TextInputDemo");
        jFrame.setDefaultCloseOperation(3);
        TextInputDemo textInputDemo = new TextInputDemo();
        textInputDemo.setOpaque(true);
        jFrame.setContentPane(textInputDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TextInputDemo.createAndShowGUI();
            }
        });
    }
}

