/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FormattedTextFieldDemo
extends JPanel
implements PropertyChangeListener {
    private double amount = 100000.0;
    private double rate = 7.5;
    private int numPeriods = 30;
    private JLabel amountLabel;
    private JLabel rateLabel;
    private JLabel numPeriodsLabel;
    private JLabel paymentLabel;
    private static String amountString = "Loan Amount: ";
    private static String rateString = "APR (%): ";
    private static String numPeriodsString = "Years: ";
    private static String paymentString = "Monthly Payment: ";
    private JFormattedTextField amountField;
    private JFormattedTextField rateField;
    private JFormattedTextField numPeriodsField;
    private JFormattedTextField paymentField;
    private NumberFormat amountFormat;
    private NumberFormat percentFormat;
    private NumberFormat paymentFormat;

    public FormattedTextFieldDemo() {
        super(new BorderLayout());
        this.setUpFormats();
        double d = this.computePayment(this.amount, this.rate, this.numPeriods);
        this.amountLabel = new JLabel(amountString);
        this.rateLabel = new JLabel(rateString);
        this.numPeriodsLabel = new JLabel(numPeriodsString);
        this.paymentLabel = new JLabel(paymentString);
        this.amountField = new JFormattedTextField(this.amountFormat);
        this.amountField.setValue(new Double(this.amount));
        this.amountField.setColumns(10);
        this.amountField.addPropertyChangeListener("value", this);
        this.rateField = new JFormattedTextField(this.percentFormat);
        this.rateField.setValue(new Double(this.rate));
        this.rateField.setColumns(10);
        this.rateField.addPropertyChangeListener("value", this);
        this.numPeriodsField = new JFormattedTextField();
        this.numPeriodsField.setValue(new Integer(this.numPeriods));
        this.numPeriodsField.setColumns(10);
        this.numPeriodsField.addPropertyChangeListener("value", this);
        this.paymentField = new JFormattedTextField(this.paymentFormat);
        this.paymentField.setValue(new Double(d));
        this.paymentField.setColumns(10);
        this.paymentField.setEditable(false);
        this.paymentField.setForeground(Color.red);
        this.amountLabel.setLabelFor(this.amountField);
        this.rateLabel.setLabelFor(this.rateField);
        this.numPeriodsLabel.setLabelFor(this.numPeriodsField);
        this.paymentLabel.setLabelFor(this.paymentField);
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(this.amountLabel);
        jPanel.add(this.rateLabel);
        jPanel.add(this.numPeriodsLabel);
        jPanel.add(this.paymentLabel);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.add(this.amountField);
        jPanel2.add(this.rateField);
        jPanel2.add(this.numPeriodsField);
        jPanel2.add(this.paymentField);
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "After");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object == this.amountField) {
            this.amount = ((Number)this.amountField.getValue()).doubleValue();
        } else if (object == this.rateField) {
            this.rate = ((Number)this.rateField.getValue()).doubleValue();
        } else if (object == this.numPeriodsField) {
            this.numPeriods = ((Number)this.numPeriodsField.getValue()).intValue();
        }
        double d = this.computePayment(this.amount, this.rate, this.numPeriods);
        this.paymentField.setValue(new Double(d));
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("FormattedTextFieldDemo");
        jFrame.setDefaultCloseOperation(3);
        FormattedTextFieldDemo formattedTextFieldDemo = new FormattedTextFieldDemo();
        formattedTextFieldDemo.setOpaque(true);
        jFrame.setContentPane(formattedTextFieldDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FormattedTextFieldDemo.createAndShowGUI();
            }
        });
    }

    double computePayment(double d, double d2, int n) {
        double d3;
        n *= 12;
        if (d2 > 0.01) {
            double d4 = d2 / 100.0 / 12.0;
            double d5 = Math.pow(1.0 + d4, 0.0 - (double)n);
            d3 = (1.0 - d5) / d4;
        } else {
            d3 = n;
        }
        double d6 = -1.0 * d / d3;
        return d6;
    }

    private void setUpFormats() {
        this.amountFormat = NumberFormat.getNumberInstance();
        this.percentFormat = NumberFormat.getNumberInstance();
        this.percentFormat.setMinimumFractionDigits(3);
        this.paymentFormat = NumberFormat.getCurrencyInstance();
    }
}

