/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class MouseMotionEventDemo
extends JPanel
implements MouseMotionListener {
    BlankArea blankArea;
    JTextArea textArea;
    static final String newline = "\n";

    public MouseMotionEventDemo() {
        super(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.blankArea = new BlankArea(new Color(0.98f, 0.97f, 0.85f));
        gridBagLayout.setConstraints(this.blankArea, gridBagConstraints);
        this.add(this.blankArea);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea, 22, 30);
        jScrollPane.setPreferredSize(new Dimension(200, 75));
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
        this.blankArea.addMouseMotionListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(new Dimension(450, 450));
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.saySomething("Mouse moved", mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.saySomething("Mouse dragged", mouseEvent);
    }

    void saySomething(String string, MouseEvent mouseEvent) {
        this.textArea.append(string + " (" + mouseEvent.getX() + "," + mouseEvent.getY() + ")" + " detected on " + mouseEvent.getComponent().getClass().getName() + newline);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("MouseMotionEventDemo");
        jFrame.setDefaultCloseOperation(3);
        MouseMotionEventDemo mouseMotionEventDemo = new MouseMotionEventDemo();
        mouseMotionEventDemo.setOpaque(true);
        jFrame.setContentPane(mouseMotionEventDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MouseMotionEventDemo.createAndShowGUI();
            }
        });
    }
}

