/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ComponentEventDemo
extends JPanel
implements ComponentListener,
ItemListener {
    static JFrame frame;
    JTextArea display = new JTextArea();
    JLabel label;
    String newline = "\n";

    public ComponentEventDemo() {
        super(new BorderLayout());
        this.display.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.display);
        jScrollPane.setPreferredSize(new Dimension(350, 200));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.label = new JLabel("This is a label", 0);
        this.label.addComponentListener(this);
        jPanel.add((Component)this.label, "Center");
        JCheckBox jCheckBox = new JCheckBox("Label visible", true);
        jCheckBox.addItemListener(this);
        jCheckBox.addComponentListener(this);
        jPanel.add((Component)jCheckBox, "Last");
        jPanel.addComponentListener(this);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "Last");
        frame.addComponentListener(this);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.label.setVisible(true);
            this.label.revalidate();
            this.label.repaint();
        } else {
            this.label.setVisible(false);
        }
    }

    protected void displayMessage(String string) {
        if (this.display.isShowing()) {
            this.display.append(string + this.newline);
            this.display.setCaretPosition(this.display.getDocument().getLength());
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.displayMessage("componentHidden event from " + componentEvent.getComponent().getClass().getName());
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.displayMessage("componentMoved event from " + component.getClass().getName() + "; new location: " + component.getLocation().x + ", " + component.getLocation().y);
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.displayMessage("componentResized event from " + component.getClass().getName() + "; new size: " + component.getSize().width + ", " + component.getSize().height);
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.displayMessage("componentShown event from " + componentEvent.getComponent().getClass().getName());
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        frame = new JFrame("ComponentEventDemo");
        frame.setDefaultCloseOperation(3);
        ComponentEventDemo componentEventDemo = new ComponentEventDemo();
        componentEventDemo.setOpaque(true);
        frame.setContentPane(componentEventDemo);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentEventDemo.createAndShowGUI();
            }
        });
    }
}

