/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SwingApplication
implements ActionListener {
    private static String labelPrefix = "Number of button clicks: ";
    private int numClicks = 0;
    final JLabel label = new JLabel(labelPrefix + "0    ");
    static final String LOOKANDFEEL = null;

    public Component createComponents() {
        JButton jButton = new JButton("I'm a Swing button!");
        jButton.setMnemonic(73);
        jButton.addActionListener(this);
        this.label.setLabelFor(jButton);
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(30, 30, 10, 30));
        jPanel.add(jButton);
        jPanel.add(this.label);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ++this.numClicks;
        this.label.setText(labelPrefix + this.numClicks);
    }

    private static void initLookAndFeel() {
        String string = null;
        if (LOOKANDFEEL != null) {
            if (LOOKANDFEEL.equals("Metal")) {
                string = UIManager.getCrossPlatformLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals("System")) {
                string = UIManager.getSystemLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals("Motif")) {
                string = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if (LOOKANDFEEL.equals("GTK+")) {
                string = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else {
                System.err.println("Unexpected value of LOOKANDFEEL specified: " + LOOKANDFEEL);
                string = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Couldn't find class for specified look and feel:" + string);
                System.err.println("Did you include the L&F library in the class path?");
                System.err.println("Using the default look and feel.");
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                System.err.println("Can't use the specified look and feel (" + string + ") on this platform.");
                System.err.println("Using the default look and feel.");
            }
            catch (Exception exception) {
                System.err.println("Couldn't get specified look and feel (" + string + "), for some reason.");
                System.err.println("Using the default look and feel.");
                exception.printStackTrace();
            }
        }
    }

    private static void createAndShowGUI() {
        SwingApplication.initLookAndFeel();
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("SwingApplication");
        jFrame.setDefaultCloseOperation(3);
        SwingApplication swingApplication = new SwingApplication();
        Component component = swingApplication.createComponents();
        jFrame.getContentPane().add(component, "Center");
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingApplication.createAndShowGUI();
            }
        });
    }
}

