/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;

class StarPanel
extends JPanel {
    Image img;
    int w;
    int h;

    public StarPanel(Image image) {
        this.img = image;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.setBackground(Color.white);
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = new Font("Helvetica", 1, this.w / 10);
        String string = new String("The Starry Night");
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        AffineTransform affineTransform = new AffineTransform();
        Shape shape = textLayout.getOutline(null);
        Rectangle rectangle = shape.getBounds();
        affineTransform = graphics2D.getTransform();
        affineTransform.translate(this.w / 2 - rectangle.width / 2, this.h / 2 + rectangle.height / 2);
        graphics2D.transform(affineTransform);
        graphics2D.setColor(Color.blue);
        graphics2D.draw(shape);
        graphics2D.setClip(shape);
        graphics2D.drawImage(this.img, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
    }
}

