/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class IconDisplayer
extends JComponent {
    private Icon icon;
    private int preferredNumImages = 2;
    private int pad = 5;
    private Rectangle iconRect = new Rectangle();
    private Rectangle clipRect = new Rectangle();
    static /* synthetic */ Class class$IconDisplayer;

    public IconDisplayer(Icon icon, int n, int n2) {
        this.icon = icon;
        if (n > 0) {
            this.preferredNumImages = n;
        }
        if (n2 >= 0) {
            this.pad = n2;
        }
        if (this.pad > 0) {
            this.setBorder(BorderFactory.createEmptyBorder(this.pad, this.pad, this.pad, this.pad));
        }
    }

    public Dimension getPreferredSize() {
        if (this.icon != null) {
            Insets insets = this.getInsets();
            return new Dimension(this.icon.getIconWidth() * this.preferredNumImages + this.pad * (this.preferredNumImages - 1) + insets.left + insets.right, this.icon.getIconHeight() + insets.top + insets.bottom);
        }
        return new Dimension(100, 100);
    }

    public Dimension getMinimumSize() {
        if (this.icon != null) {
            Insets insets = this.getInsets();
            return new Dimension(this.icon.getIconWidth() + insets.left + insets.right, this.icon.getIconHeight() + insets.top + insets.bottom);
        }
        return new Dimension(0, 0);
    }

    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.icon != null) {
            Insets insets = this.getInsets();
            int n = this.icon.getIconWidth();
            int n2 = insets.top;
            boolean bl = false;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics.getClipBounds(this.clipRect);
            for (int i = this.getWidth() - insets.right - n; i >= insets.left; i -= n + this.pad) {
                this.iconRect.setBounds(i, n2, n, this.icon.getIconHeight());
                if (!this.iconRect.intersects(this.clipRect)) continue;
                this.icon.paintIcon(this, graphics2D, i, n2);
                if (bl) continue;
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
                bl = true;
            }
            graphics2D.dispose();
        }
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = (class$IconDisplayer == null ? (class$IconDisplayer = IconDisplayer.class$("IconDisplayer")) : class$IconDisplayer).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("IconDisplayer");
        jFrame.setDefaultCloseOperation(3);
        ImageIcon imageIcon = IconDisplayer.createImageIcon("images/rocketship.gif");
        IconDisplayer iconDisplayer = new IconDisplayer(imageIcon, 5, -1);
        jFrame.getContentPane().add((Component)iconDisplayer, "Center");
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IconDisplayer.createAndShowGUI();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

