/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class WindowEventDemo
extends JPanel
implements WindowListener,
WindowFocusListener,
WindowStateListener {
    static final String newline = "\n";
    static final String space = "    ";
    static JFrame frame;
    JTextArea display = new JTextArea();

    public WindowEventDemo() {
        super(new BorderLayout());
        this.display.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.display);
        jScrollPane.setPreferredSize(new Dimension(500, 450));
        this.add((Component)jScrollPane, "Center");
        frame.addWindowListener(this);
        frame.addWindowFocusListener(this);
        frame.addWindowStateListener(this);
        this.checkWM();
    }

    public void checkWM() {
        Toolkit toolkit = frame.getToolkit();
        if (!toolkit.isFrameStateSupported(1)) {
            this.displayMessage("Your window manager doesn't support ICONIFIED.");
        }
        if (!toolkit.isFrameStateSupported(4)) {
            this.displayMessage("Your window manager doesn't support MAXIMIZED_VERT.");
        }
        if (!toolkit.isFrameStateSupported(2)) {
            this.displayMessage("Your window manager doesn't support MAXIMIZED_HORIZ.");
        }
        if (!toolkit.isFrameStateSupported(6)) {
            this.displayMessage("Your window manager doesn't support MAXIMIZED_BOTH.");
        } else {
            this.displayMessage("Your window manager supports MAXIMIZED_BOTH.");
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.displayMessage("WindowListener method called: windowClosing.");
        ActionListener actionListener = new ActionListener(){
            boolean alreadyDisposed = false;

            public void actionPerformed(ActionEvent actionEvent) {
                if (!this.alreadyDisposed) {
                    this.alreadyDisposed = true;
                    frame.dispose();
                } else {
                    System.exit(0);
                }
            }
        };
        Timer timer = new Timer(500, actionListener);
        timer.setInitialDelay(2000);
        timer.start();
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.displayMessage("WindowListener method called: windowClosed.");
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.displayMessage("WindowListener method called: windowOpened.");
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.displayMessage("WindowListener method called: windowIconified.");
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.displayMessage("WindowListener method called: windowDeiconified.");
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.displayMessage("WindowListener method called: windowActivated.");
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.displayMessage("WindowListener method called: windowDeactivated.");
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
        this.displayMessage("WindowFocusListener method called: windowGainedFocus.");
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        this.displayMessage("WindowFocusListener method called: windowLostFocus.");
    }

    public void windowStateChanged(WindowEvent windowEvent) {
        this.displayStateMessage("WindowStateListener method called: windowStateChanged.", windowEvent);
    }

    void displayMessage(String string) {
        this.display.append(string + newline);
        System.out.println(string);
    }

    void displayStateMessage(String string, WindowEvent windowEvent) {
        int n = windowEvent.getNewState();
        int n2 = windowEvent.getOldState();
        String string2 = string + newline + space + "New state: " + this.convertStateToString(n) + newline + space + "Old state: " + this.convertStateToString(n2);
        this.display.append(string2 + newline);
        System.out.println(string2);
    }

    String convertStateToString(int n) {
        if (n == 0) {
            return "NORMAL";
        }
        if ((n & 1) != 0) {
            return "ICONIFIED";
        }
        if ((n & 6) == 6) {
            return "MAXIMIZED_BOTH";
        }
        if ((n & 4) != 0) {
            return "MAXIMIZED_VERT";
        }
        if ((n & 2) != 0) {
            return "MAXIMIZED_HORIZ";
        }
        return "UNKNOWN";
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        frame = new JFrame("WindowEventDemo");
        frame.setDefaultCloseOperation(0);
        WindowEventDemo windowEventDemo = new WindowEventDemo();
        windowEventDemo.setOpaque(true);
        frame.setContentPane(windowEventDemo);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowEventDemo.createAndShowGUI();
            }
        });
    }
}

