/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class MouseEventDemo
extends JPanel
implements MouseListener {
    BlankArea blankArea;
    JTextArea textArea;
    static final String newline = "\n";

    public MouseEventDemo() {
        super(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.blankArea = new BlankArea(new Color(0.98f, 0.97f, 0.85f));
        gridBagLayout.setConstraints(this.blankArea, gridBagConstraints);
        this.add(this.blankArea);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(200, 75));
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
        this.blankArea.addMouseListener(this);
        this.addMouseListener(this);
        this.setPreferredSize(new Dimension(450, 450));
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.saySomething("Mouse pressed (# of clicks: " + mouseEvent.getClickCount() + ")", mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.saySomething("Mouse released (# of clicks: " + mouseEvent.getClickCount() + ")", mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.saySomething("Mouse entered", mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.saySomething("Mouse exited", mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.saySomething("Mouse clicked (# of clicks: " + mouseEvent.getClickCount() + ")", mouseEvent);
    }

    void saySomething(String string, MouseEvent mouseEvent) {
        this.textArea.append(string + " detected on " + mouseEvent.getComponent().getClass().getName() + "." + newline);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("MouseEventDemo");
        jFrame.setDefaultCloseOperation(3);
        MouseEventDemo mouseEventDemo = new MouseEventDemo();
        mouseEventDemo.setOpaque(true);
        jFrame.setContentPane(mouseEventDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MouseEventDemo.createAndShowGUI();
            }
        });
    }
}

