/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListSelectionDemo
extends JPanel {
    JTextArea output;
    JList list;
    JTable table;
    String newline = "\n";
    ListSelectionModel listSelectionModel;

    public ListSelectionDemo() {
        super(new BorderLayout());
        String[] stringArray = new String[]{"one", "two", "three", "four", "five", "six", "seven"};
        Object[] objectArray = new String[]{"French", "Spanish", "Italian"};
        Object[][] objectArray2 = new String[][]{{"un", "uno", "uno"}, {"deux", "dos", "due"}, {"trois", "tres", "tre"}, {"quatre", "cuatro", "quattro"}, {"cinq", "cinco", "cinque"}, {"six", "seis", "sei"}, {"sept", "siete", "sette"}};
        this.list = new JList<String>(stringArray);
        this.listSelectionModel = this.list.getSelectionModel();
        this.listSelectionModel.addListSelectionListener(new SharedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.table = new JTable(objectArray2, objectArray);
        this.table.setSelectionModel(this.listSelectionModel);
        JScrollPane jScrollPane2 = new JScrollPane(this.table);
        JPanel jPanel = new JPanel();
        String[] stringArray2 = new String[]{"SINGLE_SELECTION", "SINGLE_INTERVAL_SELECTION", "MULTIPLE_INTERVAL_SELECTION"};
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray2);
        jComboBox.setSelectedIndex(2);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)jComboBox.getSelectedItem();
                if (string.equals("SINGLE_SELECTION")) {
                    ListSelectionDemo.this.listSelectionModel.setSelectionMode(0);
                } else if (string.equals("SINGLE_INTERVAL_SELECTION")) {
                    ListSelectionDemo.this.listSelectionModel.setSelectionMode(1);
                } else {
                    ListSelectionDemo.this.listSelectionModel.setSelectionMode(2);
                }
                ListSelectionDemo.this.output.append("----------Mode: " + string + "----------" + ListSelectionDemo.this.newline);
            }
        });
        jPanel.add(new JLabel("Selection mode:"));
        jPanel.add(jComboBox);
        this.output = new JTextArea(1, 10);
        this.output.setEditable(false);
        JScrollPane jScrollPane3 = new JScrollPane(this.output, 22, 30);
        JSplitPane jSplitPane = new JSplitPane(0);
        this.add((Component)jSplitPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel3.setBorder(BorderFactory.createTitledBorder("List"));
        jPanel3.add(jScrollPane);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder("Table"));
        jPanel4.add(jScrollPane2);
        jScrollPane2.setPreferredSize(new Dimension(300, 100));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel2.setMinimumSize(new Dimension(400, 50));
        jPanel2.setPreferredSize(new Dimension(400, 110));
        jSplitPane.add(jPanel2);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel, "First");
        jPanel5.add((Component)jScrollPane3, "Center");
        jPanel5.setPreferredSize(new Dimension(450, 135));
        jSplitPane.add(jPanel5);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("ListSelectionDemo");
        jFrame.setDefaultCloseOperation(3);
        ListSelectionDemo listSelectionDemo = new ListSelectionDemo();
        listSelectionDemo.setOpaque(true);
        jFrame.setContentPane(listSelectionDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ListSelectionDemo.createAndShowGUI();
            }
        });
    }

    class SharedListSelectionHandler
    implements ListSelectionListener {
        SharedListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            int n = listSelectionEvent.getFirstIndex();
            int n2 = listSelectionEvent.getLastIndex();
            boolean bl = listSelectionEvent.getValueIsAdjusting();
            ListSelectionDemo.this.output.append("Event for indexes " + n + " - " + n2 + "; isAdjusting is " + bl + "; selected indexes:");
            if (listSelectionModel.isSelectionEmpty()) {
                ListSelectionDemo.this.output.append(" <none>");
            } else {
                int n3 = listSelectionModel.getMinSelectionIndex();
                int n4 = listSelectionModel.getMaxSelectionIndex();
                for (int i = n3; i <= n4; ++i) {
                    if (!listSelectionModel.isSelectedIndex(i)) continue;
                    ListSelectionDemo.this.output.append(" " + i);
                }
            }
            ListSelectionDemo.this.output.append(ListSelectionDemo.this.newline);
            ListSelectionDemo.this.output.setCaretPosition(ListSelectionDemo.this.output.getDocument().getLength());
        }
    }
}

