/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SplitPaneDemo
implements ListSelectionListener {
    private Vector imageNames;
    private JLabel picture;
    private JList list;
    private JSplitPane splitPane;
    static /* synthetic */ Class class$SplitPaneDemo;

    public SplitPaneDemo() {
        Object object;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("imagenames");
            object = resourceBundle.getString("images");
            this.imageNames = SplitPaneDemo.parseList((String)object);
        }
        catch (MissingResourceException missingResourceException) {
            this.handleMissingResource(missingResourceException);
        }
        this.list = new JList(this.imageNames);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(this);
        object = new JScrollPane(this.list);
        ImageIcon imageIcon = SplitPaneDemo.createImageIcon("images/" + (String)this.imageNames.firstElement());
        this.picture = imageIcon != null ? new JLabel(imageIcon) : new JLabel((String)this.imageNames.firstElement());
        JScrollPane jScrollPane = new JScrollPane(this.picture);
        this.splitPane = new JSplitPane(1, (Component)object, jScrollPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(150);
        Dimension dimension = new Dimension(100, 50);
        ((JComponent)object).setMinimumSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        this.splitPane.setPreferredSize(new Dimension(400, 200));
    }

    public JList getImageList() {
        return this.list;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        if (jList.isSelectionEmpty()) {
            this.picture.setIcon(null);
            this.picture.setText(null);
        } else {
            int n = jList.getSelectedIndex();
            ImageIcon imageIcon = SplitPaneDemo.createImageIcon("images/" + (String)this.imageNames.elementAt(n));
            this.picture.setIcon(imageIcon);
            if (imageIcon != null) {
                this.picture.setText(null);
            } else {
                this.picture.setText("Image not found: " + (String)this.imageNames.elementAt(n));
            }
        }
    }

    protected static Vector parseList(String string) {
        Vector<String> vector = new Vector<String>(10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            vector.addElement(string2);
        }
        return vector;
    }

    private void handleMissingResource(MissingResourceException missingResourceException) {
        System.err.println();
        System.err.println("Can't find the properties file that contains the image names.");
        System.err.println("Its name should be imagenames.properties, and it should");
        System.err.println("contain a single line that specifies one or more image");
        System.err.println("files to be found in a directory named images.  Example:");
        System.err.println();
        System.err.println("    images=Bird.gif Cat.gif Dog.gif");
        System.err.println();
        throw missingResourceException;
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = (class$SplitPaneDemo == null ? (class$SplitPaneDemo = SplitPaneDemo.class$("SplitPaneDemo")) : class$SplitPaneDemo).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("SplitPaneDemo");
        jFrame.setDefaultCloseOperation(3);
        SplitPaneDemo splitPaneDemo = new SplitPaneDemo();
        jFrame.getContentPane().add(splitPaneDemo.getSplitPane());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SplitPaneDemo.createAndShowGUI();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

