/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;

public class SizeDisplayer
extends JComponent {
    private Icon icon;
    private String text;
    private int xTextPad = 5;
    private int yTextPad = 5;
    private Rectangle textSizeR = new Rectangle();
    private Dimension textSizeD = new Dimension();
    private Dimension userPreferredSize;
    private Dimension userMinimumSize;
    private Dimension userMaximumSize;

    public SizeDisplayer(String string, Icon icon) {
        this.text = string;
        this.icon = icon;
        this.setOpaque(true);
    }

    protected void paintComponent(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Dimension dimension = this.getMinimumSize();
        Dimension dimension2 = this.getPreferredSize();
        Dimension dimension3 = this.getSize();
        int n = 0;
        int n2 = 0;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, dimension3.width, dimension3.height);
        }
        if (this.icon != null) {
            object = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
            this.icon.paintIcon(this, graphics2D, (dimension3.width - this.icon.getIconWidth()) / 2, (dimension3.height - this.icon.getIconHeight()) / 2);
            graphics2D.setComposite((Composite)object);
        }
        n = (dimension3.width - dimension2.width) / 2;
        n2 = (dimension3.height - dimension2.height) / 2;
        graphics2D.setColor(Color.RED);
        graphics2D.drawRect(n, n2, dimension2.width - 1, dimension2.height - 1);
        if (dimension.width != dimension2.width || dimension.height != dimension2.height) {
            int n3 = (dimension3.width - dimension.width) / 2;
            int n4 = (dimension3.height - dimension.height) / 2;
            graphics2D.setColor(Color.CYAN);
            graphics2D.drawRect(n3, n4, dimension.width - 1, dimension.height - 1);
        }
        if (this.text != null) {
            object = this.getTextSize(graphics2D);
            graphics2D.setColor(this.getForeground());
            graphics2D.drawString(this.text, (dimension3.width - ((Dimension)object).width) / 2, (dimension3.height - ((Dimension)object).height) / 2 + graphics2D.getFontMetrics().getAscent());
        }
        graphics2D.dispose();
    }

    private Dimension getTextSize(Graphics2D graphics2D) {
        if (this.text == null) {
            this.textSizeD.setSize(0, 0);
        } else {
            FontRenderContext fontRenderContext = graphics2D != null ? graphics2D.getFontRenderContext() : new FontRenderContext(null, false, false);
            Rectangle2D rectangle2D = this.getFont().getStringBounds(this.text, fontRenderContext);
            this.textSizeR.setRect(rectangle2D);
            this.textSizeD.setSize(this.textSizeR.width, this.textSizeR.height);
        }
        return this.textSizeD;
    }

    public Dimension getMinimumSize() {
        if (this.userMinimumSize != null) {
            return this.userMinimumSize;
        }
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.userPreferredSize != null) {
            return this.userPreferredSize;
        }
        return this.calculatePreferredSize();
    }

    public Dimension getMaximumSize() {
        if (this.userMaximumSize != null) {
            return this.userMaximumSize;
        }
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void setMinimumSize(Dimension dimension) {
        this.userMinimumSize = dimension;
    }

    public void setPreferredSize(Dimension dimension) {
        this.userPreferredSize = dimension;
    }

    public void setMaximumSize(Dimension dimension) {
        this.userMaximumSize = dimension;
    }

    private Dimension calculatePreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getTextSize(null);
        int n = 0;
        int n2 = 0;
        if (this.icon != null) {
            n = this.icon.getIconWidth();
            n2 = this.icon.getIconHeight();
        }
        return new Dimension(Math.max(n, dimension.width + 2 * this.xTextPad) + insets.left + insets.right, Math.max(n2, dimension.height + 2 * this.yTextPad) + insets.top + insets.bottom);
    }
}

