/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class DynamicTreeDemo
extends JPanel
implements ActionListener {
    private int newNodeSuffix = 1;
    private static String ADD_COMMAND = "add";
    private static String REMOVE_COMMAND = "remove";
    private static String CLEAR_COMMAND = "clear";
    private DynamicTree treePanel = new DynamicTree();

    public DynamicTreeDemo() {
        super(new BorderLayout());
        this.populateTree(this.treePanel);
        JButton jButton = new JButton("Add");
        jButton.setActionCommand(ADD_COMMAND);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Remove");
        jButton2.setActionCommand(REMOVE_COMMAND);
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("Clear");
        jButton3.setActionCommand(CLEAR_COMMAND);
        jButton3.addActionListener(this);
        this.treePanel.setPreferredSize(new Dimension(300, 150));
        this.add((Component)this.treePanel, "Center");
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        this.add((Component)jPanel, "After");
    }

    public void populateTree(DynamicTree dynamicTree) {
        String string = new String("Parent 1");
        String string2 = new String("Parent 2");
        String string3 = new String("Child 1");
        String string4 = new String("Child 2");
        DefaultMutableTreeNode defaultMutableTreeNode = dynamicTree.addObject(null, string);
        DefaultMutableTreeNode defaultMutableTreeNode2 = dynamicTree.addObject(null, string2);
        dynamicTree.addObject(defaultMutableTreeNode, string3);
        dynamicTree.addObject(defaultMutableTreeNode, string4);
        dynamicTree.addObject(defaultMutableTreeNode2, string3);
        dynamicTree.addObject(defaultMutableTreeNode2, string4);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (ADD_COMMAND.equals(string)) {
            this.treePanel.addObject("New Node " + this.newNodeSuffix++);
        } else if (REMOVE_COMMAND.equals(string)) {
            this.treePanel.removeCurrentNode();
        } else if (CLEAR_COMMAND.equals(string)) {
            this.treePanel.clear();
        }
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("DynamicTreeDemo");
        jFrame.setDefaultCloseOperation(3);
        DynamicTreeDemo dynamicTreeDemo = new DynamicTreeDemo();
        dynamicTreeDemo.setOpaque(true);
        jFrame.setContentPane(dynamicTreeDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DynamicTreeDemo.createAndShowGUI();
            }
        });
    }
}

