/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BoxLayoutDemo2
implements ItemListener {
    protected static int NUM_COMPONENTS = 3;
    protected static float[] xAlignment = new float[]{0.0f, 0.5f, 1.0f};
    protected static float[] hue = new float[]{0.0f, 0.33f, 0.67f};
    protected static boolean restrictSize = true;
    protected static boolean sizeIsRandom = false;
    protected static BLDComponent[] bldComponent = new BLDComponent[NUM_COMPONENTS];

    public void populateContentPane(Container container) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        int n = 15;
        for (int i = 0; i < NUM_COMPONENTS; ++i) {
            n = sizeIsRandom ? (int)(30.0 * Math.random()) + 30 : (n += 10);
            BoxLayoutDemo2.bldComponent[i] = new BLDComponent(xAlignment[i], hue[i], n, restrictSize, sizeIsRandom, String.valueOf(i));
            jPanel.add(bldComponent[i]);
        }
        JLabel jLabel = new JLabel("Click a rectangle to change its X alignment.");
        JCheckBox jCheckBox = new JCheckBox("Restrict maximum rectangle size.");
        jCheckBox.setSelected(restrictSize);
        jCheckBox.addItemListener(this);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.red));
        Box box = Box.createVerticalBox();
        box.add(jLabel);
        box.add(jCheckBox);
        container.add((Component)jPanel, "Center");
        container.add((Component)box, "Last");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        restrictSize = itemEvent.getStateChange() == 1;
        BoxLayoutDemo2.notifyBLDComponents();
    }

    public static void notifyBLDComponents() {
        for (int i = 0; i < NUM_COMPONENTS; ++i) {
            bldComponent[i].setSizeRestriction(restrictSize);
        }
        bldComponent[0].revalidate();
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("BoxLayoutDemo2");
        jFrame.setDefaultCloseOperation(3);
        BoxLayoutDemo2 boxLayoutDemo2 = new BoxLayoutDemo2();
        boxLayoutDemo2.populateContentPane(jFrame.getContentPane());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BoxLayoutDemo2.createAndShowGUI();
            }
        });
    }
}

