/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FrameDemo2
extends WindowAdapter
implements ActionListener {
    private Point lastLocation = null;
    private int maxX = 500;
    private int maxY = 500;
    private static JButton defaultButton = null;
    protected static final String NO_DECORATIONS = "no_dec";
    protected static final String LF_DECORATIONS = "laf_dec";
    protected static final String WS_DECORATIONS = "ws_dec";
    protected static final String CREATE_WINDOW = "new_win";
    protected static final String DEFAULT_ICON = "def_icon";
    protected static final String FILE_ICON = "file_icon";
    protected static final String PAINT_ICON = "paint_icon";
    protected boolean noDecorations = false;
    protected boolean specifyIcon = false;
    protected boolean createIcon = false;
    static /* synthetic */ Class class$FrameDemo2;

    public FrameDemo2() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.maxX = dimension.width - 50;
        this.maxY = dimension.height - 50;
    }

    public void showNewWindow() {
        MyFrame myFrame = new MyFrame();
        if (this.noDecorations) {
            myFrame.setUndecorated(true);
        }
        if (this.lastLocation != null) {
            this.lastLocation.translate(40, 40);
            if (this.lastLocation.x > this.maxX || this.lastLocation.y > this.maxY) {
                this.lastLocation.setLocation(0, 0);
            }
            myFrame.setLocation(this.lastLocation);
        } else {
            this.lastLocation = myFrame.getLocation();
        }
        if (this.specifyIcon) {
            if (this.createIcon) {
                myFrame.setIconImage(FrameDemo2.createFDImage());
            } else {
                myFrame.setIconImage(FrameDemo2.getFDImage());
            }
        }
        myFrame.setSize(new Dimension(170, 100));
        myFrame.setVisible(true);
    }

    protected JComponent createOptionControls() {
        JLabel jLabel = new JLabel("Decoration options for subsequently created frames:");
        ButtonGroup buttonGroup = new ButtonGroup();
        JLabel jLabel2 = new JLabel("Icon options:");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setText("Look and feel decorated");
        jRadioButton.setActionCommand(LF_DECORATIONS);
        jRadioButton.addActionListener(this);
        jRadioButton.setSelected(true);
        buttonGroup.add(jRadioButton);
        JRadioButton jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Window system decorated");
        jRadioButton2.setActionCommand(WS_DECORATIONS);
        jRadioButton2.addActionListener(this);
        buttonGroup.add(jRadioButton2);
        JRadioButton jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("No decorations");
        jRadioButton3.setActionCommand(NO_DECORATIONS);
        jRadioButton3.addActionListener(this);
        buttonGroup.add(jRadioButton3);
        JRadioButton jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("Default icon");
        jRadioButton4.setActionCommand(DEFAULT_ICON);
        jRadioButton4.addActionListener(this);
        jRadioButton4.setSelected(true);
        buttonGroup2.add(jRadioButton4);
        JRadioButton jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("Icon from a JPEG file");
        jRadioButton5.setActionCommand(FILE_ICON);
        jRadioButton5.addActionListener(this);
        buttonGroup2.add(jRadioButton5);
        JRadioButton jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Painted icon");
        jRadioButton6.setActionCommand(PAINT_ICON);
        jRadioButton6.addActionListener(this);
        buttonGroup2.add(jRadioButton6);
        Box box = Box.createVerticalBox();
        box.add(jLabel);
        box.add(Box.createVerticalStrut(5));
        box.add(jRadioButton);
        box.add(jRadioButton2);
        box.add(jRadioButton3);
        box.add(Box.createVerticalStrut(15));
        box.add(jLabel2);
        box.add(Box.createVerticalStrut(5));
        box.add(jRadioButton4);
        box.add(jRadioButton5);
        box.add(jRadioButton6);
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return box;
    }

    protected JComponent createButtonPane() {
        JButton jButton = new JButton("New window");
        jButton.setActionCommand(CREATE_WINDOW);
        jButton.addActionListener(this);
        defaultButton = jButton;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(jButton);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (CREATE_WINDOW.equals(string)) {
            this.showNewWindow();
        } else if (NO_DECORATIONS.equals(string)) {
            this.noDecorations = true;
            JFrame.setDefaultLookAndFeelDecorated(false);
        } else if (WS_DECORATIONS.equals(string)) {
            this.noDecorations = false;
            JFrame.setDefaultLookAndFeelDecorated(false);
        } else if (LF_DECORATIONS.equals(string)) {
            this.noDecorations = false;
            JFrame.setDefaultLookAndFeelDecorated(true);
        } else if (DEFAULT_ICON.equals(string)) {
            this.specifyIcon = false;
        } else if (FILE_ICON.equals(string)) {
            this.specifyIcon = true;
            this.createIcon = false;
        } else if (PAINT_ICON.equals(string)) {
            this.specifyIcon = true;
            this.createIcon = true;
        }
    }

    protected static Image createFDImage() {
        BufferedImage bufferedImage = new BufferedImage(16, 16, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, 15, 15);
        graphics.setColor(Color.RED);
        graphics.fillOval(5, 3, 6, 6);
        graphics.dispose();
        return bufferedImage;
    }

    protected static Image getFDImage() {
        URL uRL = (class$FrameDemo2 == null ? (class$FrameDemo2 = FrameDemo2.class$("FrameDemo2")) : class$FrameDemo2).getResource("images/FD.jpg");
        if (uRL != null) {
            return new ImageIcon(uRL).getImage();
        }
        return null;
    }

    private static void createAndShowGUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("FrameDemo2");
        jFrame.setDefaultCloseOperation(3);
        FrameDemo2 frameDemo2 = new FrameDemo2();
        Container container = jFrame.getContentPane();
        container.add((Component)frameDemo2.createOptionControls(), "Center");
        container.add((Component)frameDemo2.createButtonPane(), "Last");
        jFrame.getRootPane().setDefaultButton(defaultButton);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FrameDemo2.createAndShowGUI();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MyFrame
    extends JFrame
    implements ActionListener {
        public MyFrame() {
            super("A window");
            this.setDefaultCloseOperation(2);
            JButton jButton = new JButton("Close window");
            jButton.addActionListener(this);
            Container container = this.getContentPane();
            container.setLayout(new BoxLayout(container, 3));
            container.add(Box.createVerticalGlue());
            container.add(jButton);
            jButton.setAlignmentX(0.5f);
            container.add(Box.createVerticalStrut(5));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

