/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FocusEventDemo
extends JPanel
implements FocusListener {
    static final String newline = "\n";
    JTextArea display;

    public FocusEventDemo() {
        super(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JTextField jTextField = new JTextField("A TextField");
        jTextField.setMargin(new Insets(0, 2, 0, 2));
        jTextField.addFocusListener(this);
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        this.add(jTextField);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel("A Label");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jLabel.addFocusListener(this);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        String string = "ComboBox Item #";
        Vector<String> vector = new Vector<String>(15);
        for (int i = 0; i < 15; ++i) {
            vector.addElement(string + i);
        }
        JComboBox jComboBox = new JComboBox(vector);
        jComboBox.addFocusListener(this);
        gridBagLayout.setConstraints(jComboBox, gridBagConstraints);
        this.add(jComboBox);
        gridBagConstraints.gridwidth = 0;
        JButton jButton = new JButton("A Button");
        jButton.addFocusListener(this);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 1;
        String string2 = "List Item #";
        Vector<String> vector2 = new Vector<String>(15);
        for (int i = 0; i < 15; ++i) {
            vector2.addElement(string2 + i);
        }
        JList jList = new JList(vector2);
        jList.setSelectedIndex(1);
        jList.addFocusListener(this);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        jScrollPane.getHorizontalScrollBar().setFocusable(false);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 0;
        this.display = new JTextArea();
        this.display.setEditable(false);
        this.display.setRequestFocusEnabled(false);
        this.display.addFocusListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.display);
        jScrollPane2.getHorizontalScrollBar().setFocusable(false);
        jScrollPane2.getVerticalScrollBar().setFocusable(false);
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        this.add(jScrollPane2);
        this.setPreferredSize(new Dimension(450, 450));
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    public void focusGained(FocusEvent focusEvent) {
        this.displayMessage("Focus gained", focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.displayMessage("Focus lost", focusEvent);
    }

    void displayMessage(String string, FocusEvent focusEvent) {
        this.display.append(string + (focusEvent.isTemporary() ? " (temporary):" : ":") + focusEvent.getComponent().getClass().getName() + "; Opposite component: " + (focusEvent.getOppositeComponent() != null ? focusEvent.getOppositeComponent().getClass().getName() : "null") + newline);
        this.display.setCaretPosition(this.display.getDocument().getLength());
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("FocusEventDemo");
        jFrame.setDefaultCloseOperation(3);
        FocusEventDemo focusEventDemo = new FocusEventDemo();
        focusEventDemo.setOpaque(true);
        jFrame.setContentPane(focusEventDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FocusEventDemo.createAndShowGUI();
            }
        });
    }
}

