/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ScrollDemo2
extends JPanel
implements MouseListener {
    private Dimension area;
    private Vector circles;
    private JPanel drawingPane;
    private final Color[] colors = new Color[]{Color.red, Color.blue, Color.green, Color.orange, Color.cyan, Color.magenta, Color.darkGray, Color.yellow};
    private final int color_n = this.colors.length;

    public ScrollDemo2() {
        super(new BorderLayout());
        this.area = new Dimension(0, 0);
        this.circles = new Vector();
        JLabel jLabel = new JLabel("Click left mouse button to place a circle.");
        JLabel jLabel2 = new JLabel("Click right mouse button to clear drawing area.");
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        this.drawingPane = new DrawingPane();
        this.drawingPane.setBackground(Color.white);
        this.drawingPane.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.drawingPane);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        this.add((Component)jPanel, "First");
        this.add((Component)jScrollPane, "Center");
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl = false;
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.circles.removeAllElements();
            this.area.width = 0;
            this.area.height = 0;
            bl = true;
        } else {
            int n;
            int n2 = mouseEvent.getX() - 50;
            int n3 = mouseEvent.getY() - 50;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            Rectangle rectangle = new Rectangle(n2, n3, 100, 100);
            this.circles.addElement(rectangle);
            this.drawingPane.scrollRectToVisible(rectangle);
            int n4 = n2 + 100 + 2;
            if (n4 > this.area.width) {
                this.area.width = n4;
                bl = true;
            }
            if ((n = n3 + 100 + 2) > this.area.height) {
                this.area.height = n;
                bl = true;
            }
        }
        if (bl) {
            this.drawingPane.setPreferredSize(this.area);
            this.drawingPane.revalidate();
        }
        this.drawingPane.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("ScrollDemo2");
        jFrame.setDefaultCloseOperation(3);
        ScrollDemo2 scrollDemo2 = new ScrollDemo2();
        scrollDemo2.setOpaque(true);
        jFrame.setContentPane(scrollDemo2);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public class DrawingPane
    extends JPanel {
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = 0;
            while (n < ScrollDemo2.this.circles.size()) {
                Rectangle rectangle = (Rectangle)ScrollDemo2.this.circles.elementAt(n);
                graphics.setColor(ScrollDemo2.this.colors[n % ScrollDemo2.this.color_n]);
                graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n;
            }
        }
    }
}

