/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class ColorTransferHandler
extends TransferHandler {
    String mimeType = "application/x-java-jvm-local-objectref;class=java.awt.Color";
    DataFlavor colorFlavor;
    private boolean changesForegroundColor = true;

    ColorTransferHandler() {
        try {
            this.colorFlavor = new DataFlavor(this.mimeType);
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.hasColorFlavor(transferable.getTransferDataFlavors())) {
            try {
                Color color = (Color)transferable.getTransferData(this.colorFlavor);
                if (this.getChangesForegroundColor()) {
                    jComponent.setForeground(color);
                } else {
                    jComponent.setBackground(color);
                }
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println("importData: unsupported data flavor");
            }
            catch (IOException iOException) {
                System.out.println("importData: I/O exception");
            }
        }
        return false;
    }

    protected boolean hasColorFlavor(DataFlavor[] dataFlavorArray) {
        if (this.colorFlavor == null) {
            return false;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (this.colorFlavor.equals(dataFlavorArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return this.hasColorFlavor(dataFlavorArray);
    }

    protected void setChangesForegroundColor(boolean bl) {
        this.changesForegroundColor = bl;
    }

    protected boolean getChangesForegroundColor() {
        return this.changesForegroundColor;
    }
}

