/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class ActionDemo
extends JPanel
implements ItemListener {
    protected JTextArea textArea = new JTextArea(5, 30);
    protected String newline = "\n";
    protected Action leftAction;
    protected Action middleAction;
    protected Action rightAction;
    protected JCheckBoxMenuItem[] cbmi;
    static /* synthetic */ Class class$ActionDemo;

    public ActionDemo() {
        super(new BorderLayout());
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        this.setPreferredSize(new Dimension(450, 150));
        this.add((Component)jScrollPane, "Center");
        this.leftAction = new LeftAction("Go left", ActionDemo.createNavigationIcon("Back24"), "This is the left button.", new Integer(76));
        this.middleAction = new MiddleAction("Do something", ActionDemo.createNavigationIcon("Up24"), "This is the middle button.", new Integer(77));
        this.rightAction = new RightAction("Go right", ActionDemo.createNavigationIcon("Forward24"), "This is the right button.", new Integer(82));
    }

    protected static ImageIcon createNavigationIcon(String string) {
        String string2;
        URL uRL = (class$ActionDemo == null ? (class$ActionDemo = ActionDemo.class$("ActionDemo")) : class$ActionDemo).getResource(string2 = "toolbarButtonGraphics/navigation/" + string + ".gif");
        if (uRL == null) {
            System.err.println("Resource not found: " + string2);
            return null;
        }
        return new ImageIcon(uRL);
    }

    public JMenuBar createMenuBar() {
        JMenuItem jMenuItem = null;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Menu");
        Action[] actionArray = new Action[]{this.leftAction, this.middleAction, this.rightAction};
        int n = 0;
        while (n < actionArray.length) {
            jMenuItem = new JMenuItem(actionArray[n]);
            jMenuItem.setIcon(null);
            jMenu.add(jMenuItem);
            ++n;
        }
        jMenuBar.add(jMenu);
        jMenuBar.add(this.createAbleMenu());
        return jMenuBar;
    }

    public void createToolBar() {
        JButton jButton = null;
        JToolBar jToolBar = new JToolBar();
        this.add((Component)jToolBar, "First");
        jButton = new JButton(this.leftAction);
        if (jButton.getIcon() != null) {
            jButton.setText("");
        }
        jToolBar.add(jButton);
        jButton = new JButton(this.middleAction);
        if (jButton.getIcon() != null) {
            jButton.setText("");
        }
        jToolBar.add(jButton);
        jButton = new JButton(this.rightAction);
        if (jButton.getIcon() != null) {
            jButton.setText("");
        }
        jToolBar.add(jButton);
    }

    protected JMenu createAbleMenu() {
        JMenu jMenu = new JMenu("Action State");
        this.cbmi = new JCheckBoxMenuItem[3];
        this.cbmi[0] = new JCheckBoxMenuItem("First action enabled");
        this.cbmi[1] = new JCheckBoxMenuItem("Second action enabled");
        this.cbmi[2] = new JCheckBoxMenuItem("Third action enabled");
        int n = 0;
        while (n < this.cbmi.length) {
            this.cbmi[n].setSelected(true);
            this.cbmi[n].addItemListener(this);
            jMenu.add(this.cbmi[n]);
            ++n;
        }
        return jMenu;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)itemEvent.getSource();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (jCheckBoxMenuItem == this.cbmi[0]) {
            this.leftAction.setEnabled(bl);
        } else if (jCheckBoxMenuItem == this.cbmi[1]) {
            this.middleAction.setEnabled(bl);
        } else if (jCheckBoxMenuItem == this.cbmi[2]) {
            this.rightAction.setEnabled(bl);
        }
    }

    public void displayResult(String string, ActionEvent actionEvent) {
        String string2 = "Action event detected: " + string + this.newline + "    Event source: " + actionEvent.getSource() + this.newline;
        this.textArea.append(string2);
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("ActionDemo");
        jFrame.setDefaultCloseOperation(3);
        ActionDemo actionDemo = new ActionDemo();
        jFrame.setJMenuBar(actionDemo.createMenuBar());
        actionDemo.createToolBar();
        actionDemo.setOpaque(true);
        jFrame.setContentPane(actionDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RightAction
    extends AbstractAction {
        public RightAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionDemo.this.displayResult("Action for third button/menu item", actionEvent);
        }
    }

    public class MiddleAction
    extends AbstractAction {
        public MiddleAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionDemo.this.displayResult("Action for second button/menu item", actionEvent);
        }
    }

    public class LeftAction
    extends AbstractAction {
        public LeftAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionDemo.this.displayResult("Action for first button/menu item", actionEvent);
        }
    }
}

