/*
 * @(#)RequestMessage_1_2.java	1.12 01/12/03
 *
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.corba.se.internal.iiop.messages;

import org.omg.CORBA.Principal;
import com.sun.corba.se.internal.core.ServiceContexts;
import com.sun.corba.se.internal.core.GIOPVersion;
import com.sun.corba.se.internal.iiop.ORB;
import com.sun.corba.se.internal.ior.ObjectKey;
import com.sun.corba.se.internal.iiop.CDRInputStream;
import com.sun.corba.se.internal.iiop.CDROutputStream;
import com.sun.corba.se.internal.orbutil.ORBConstants;

/**
 * This implements the GIOP 1.2 Request header.
 *
 * @author Ram Jeyaraman 05/14/2000
 * @version 1.0
 */

public final class RequestMessage_1_2 extends Message_1_2
        implements RequestMessage {

    // Instance variables

    private ORB orb = null;
    private byte response_flags = (byte) 0;
    private byte reserved[] = null;
    private TargetAddress target = null;
    private String operation = null;
    private ServiceContexts service_contexts = null;
    private ObjectKey objectKey = null;

    // Constructors

    RequestMessage_1_2(ORB orb) {
        this.orb = orb;
    }

    RequestMessage_1_2(ORB orb, int _request_id, byte _response_flags,
            byte[] _reserved, TargetAddress _target,
            String _operation, ServiceContexts _service_contexts) {
        super(Message.GIOPBigMagic, GIOPVersion.V1_2, FLAG_NO_FRAG_BIG_ENDIAN,
            Message.GIOPRequest, 0);
        this.orb = orb;
        request_id = _request_id;
        response_flags = _response_flags;
        reserved = _reserved;
        target = _target;
        operation = _operation;
        service_contexts = _service_contexts;
    }

    // Accessor methods (RequestMessage interface)

    public int getRequestId() {
        return this.request_id;
    }

    public boolean isResponseExpected() {
        /*
        case 1: LSBit[1] == 1
            not a oneway call (DII flag INV_NO_RESPONSE is false)  // Ox03
            LSBit[0] must be 1.
        case 2: LSBit[1] == 0
            if (LSB[0] == 0) // Ox00
                oneway call
            else if (LSB[0] == 1) // 0x01
                oneway call; but server may provide
                a location forward response or system exception response.
        */

        if ( (this.response_flags & RESPONSE_EXPECTED_BIT) == RESPONSE_EXPECTED_BIT ) {
            return true;
        }

        return false;
    }

    public byte[] getReserved() {
        return this.reserved;
    }

    public ObjectKey getObjectKey() {
        if (this.objectKey == null) {
	    // this will raise a MARSHAL exception upon errors.
	    this.objectKey = MessageBase.extractObjectKey(target, orb);
        }

	return this.objectKey;
    }

    public String getOperation() {
        return this.operation;
    }

    public Principal getPrincipal() {
        // REVISIT Should we throw an exception or return null ?
        return null;
    }

    public ServiceContexts getServiceContexts() {
        return this.service_contexts;
    }

    // IO methods

    public void read(org.omg.CORBA.portable.InputStream istream) {
        super.read(istream);
        this.request_id = istream.read_ulong();
        this.response_flags = istream.read_octet();
        this.reserved = new byte[3];
        for (int _o0 = 0;_o0 < (3); ++_o0) {
            this.reserved[_o0] = istream.read_octet();
        }
        this.target = TargetAddressHelper.read(istream);
        getObjectKey(); // this does AddressingDisposition check
        this.operation = istream.read_string();
        this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream, GIOPVersion.V1_2);

        // CORBA formal 00-11-0 15.4.2.2 GIOP 1.2 body must be
        // aligned on an 8 octet boundary.
        ((CDRInputStream)istream).alignOnBoundary(ORBConstants.GIOP_12_MSG_BODY_ALIGNMENT);
    }

    public void write(org.omg.CORBA.portable.OutputStream ostream) {
        super.write(ostream);
        ostream.write_ulong(this.request_id);
        ostream.write_octet(this.response_flags);
        nullCheck(this.reserved);
        if (this.reserved.length != (3)) {
            throw new org.omg.CORBA.MARSHAL(0,
                org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
        }
        for (int _i0 = 0;_i0 < (3); ++_i0) {
            ostream.write_octet(this.reserved[_i0]);
        }
        nullCheck(this.target);
        TargetAddressHelper.write(ostream, this.target);
        ostream.write_string(this.operation);
        if (this.service_contexts != null) {
	        service_contexts.write(
                (org.omg.CORBA_2_3.portable.OutputStream) ostream,
                GIOPVersion.V1_2);
	    } else {
	        ServiceContexts.writeNullServiceContext(
                (org.omg.CORBA_2_3.portable.OutputStream) ostream);
        }

        // CORBA formal 00-11-0 15.4.2.2 GIOP 1.2 body must be
        // aligned on an 8 octet boundary.
        ((CDROutputStream)ostream).alignOnBoundary(ORBConstants.GIOP_12_MSG_BODY_ALIGNMENT);
    }

    public final void callback(com.sun.corba.se.internal.iiop.MessageMediator m)
        throws java.io.IOException
    {
        m.handleInput(this);
    }
} // class RequestMessage_1_2
