/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Window;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.applet.AppletClassLoader;
import sun.applet.AppletEvent;
import sun.applet.AppletEventMulticaster;
import sun.applet.AppletListener;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletObjectInputStream;
import sun.misc.MessageUtils;
import sun.misc.Queue;

public abstract class AppletPanel
extends Panel
implements AppletStub,
Runnable {
    Applet applet;
    protected boolean doInit = true;
    AppletClassLoader loader;
    public static final int APPLET_DISPOSE = 0;
    public static final int APPLET_LOAD = 1;
    public static final int APPLET_INIT = 2;
    public static final int APPLET_START = 3;
    public static final int APPLET_STOP = 4;
    public static final int APPLET_DESTROY = 5;
    public static final int APPLET_QUIT = 6;
    public static final int APPLET_ERROR = 7;
    public static final int APPLET_RESIZE = 51234;
    public static final int APPLET_LOADING = 51235;
    public static final int APPLET_LOADING_COMPLETED = 51236;
    protected int status;
    Thread handler;
    Dimension defaultAppletSize = new Dimension(10, 10);
    Dimension currentAppletSize = new Dimension(10, 10);
    MessageUtils mu = new MessageUtils();
    Thread loaderThread = null;
    boolean loadAbortRequest = false;
    private static int threadGroupNumber = 0;
    private AppletListener listeners;
    private Queue queue = null;
    private static Hashtable classloaders = new Hashtable();
    private static AppletMessageHandler amh = new AppletMessageHandler("appletpanel");

    protected abstract String getCode();

    protected abstract String getJarFiles();

    protected abstract String getSerializedObject();

    public abstract int getWidth();

    public abstract int getHeight();

    synchronized void createAppletThread() {
        String string = "applet-" + this.getCode();
        this.loader = this.getClassLoader(this.getCodeBase(), this.getClassLoaderCacheKey());
        this.loader.grab();
        ThreadGroup threadGroup = this.loader.getThreadGroup();
        this.handler = new Thread(threadGroup, this, "thread " + string);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AppletPanel.this.handler.setContextClassLoader(AppletPanel.this.loader);
                return null;
            }
        });
        this.handler.start();
    }

    void joinAppletThread() throws InterruptedException {
        if (this.handler != null) {
            this.handler.join();
            this.handler = null;
        }
    }

    void release() {
        if (this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
    }

    public void init() {
        try {
            this.currentAppletSize.width = this.defaultAppletSize.width = this.getWidth();
            this.currentAppletSize.height = this.defaultAppletSize.height = this.getHeight();
        }
        catch (NumberFormatException numberFormatException) {
            this.status = 7;
            this.showAppletStatus("badattribute.exception");
            this.showAppletLog("badattribute.exception");
            this.showAppletException(numberFormatException);
        }
        this.setLayout(new BorderLayout());
        this.createAppletThread();
    }

    public Dimension minimumSize() {
        return new Dimension(this.defaultAppletSize.width, this.defaultAppletSize.height);
    }

    public Dimension preferredSize() {
        return new Dimension(this.currentAppletSize.width, this.currentAppletSize.height);
    }

    public synchronized void addAppletListener(AppletListener appletListener) {
        this.listeners = AppletEventMulticaster.add(this.listeners, appletListener);
    }

    public synchronized void removeAppletListener(AppletListener appletListener) {
        this.listeners = AppletEventMulticaster.remove(this.listeners, appletListener);
    }

    public void dispatchAppletEvent(int n, Object object) {
        if (this.listeners != null) {
            AppletEvent appletEvent = new AppletEvent(this, n, object);
            this.listeners.appletStateChanged(appletEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(int n) {
        AppletPanel appletPanel = this;
        synchronized (appletPanel) {
            if (this.queue == null) {
                this.queue = new Queue();
            }
            Integer n2 = new Integer(n);
            this.queue.enqueue((Object)n2);
            this.notifyAll();
        }
        if (n == 6) {
            try {
                this.joinAppletThread();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.loader == null) {
                this.loader = this.getClassLoader(this.getCodeBase(), this.getClassLoaderCacheKey());
            }
            this.release();
        }
    }

    synchronized AppletEvent getNextEvent() throws InterruptedException {
        while (this.queue == null || this.queue.isEmpty()) {
            this.wait();
        }
        Integer n = (Integer)this.queue.dequeue();
        return new AppletEvent(this, n, null);
    }

    boolean emptyEventQueue() {
        return this.queue == null || this.queue.isEmpty();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        if (thread == this.loaderThread) {
            this.runLoader();
            return;
        }
        boolean bl = false;
        while (!bl && !thread.isInterrupted()) {
            AppletEvent appletEvent;
            try {
                appletEvent = this.getNextEvent();
            }
            catch (InterruptedException interruptedException) {
                this.showAppletStatus("bail");
                return;
            }
            try {
                switch (appletEvent.getID()) {
                    case 1: {
                        if (this.okToLoad() && this.loaderThread == null) {
                            this.setLoaderThread(new Thread(this));
                            this.loaderThread.start();
                            this.loaderThread.join();
                            this.setLoaderThread(null);
                        }
                        break;
                    }
                    case 2: {
                        if (this.status != 1) {
                            this.showAppletStatus("notloaded");
                            break;
                        }
                        this.applet.resize(this.defaultAppletSize);
                        if (this.doInit) {
                            this.applet.init();
                        }
                        this.doInit = true;
                        this.validate();
                        this.status = 2;
                        this.showAppletStatus("inited");
                        break;
                    }
                    case 3: {
                        if (this.status != 2) {
                            this.showAppletStatus("notinited");
                            break;
                        }
                        this.applet.resize(this.currentAppletSize);
                        this.applet.start();
                        this.validate();
                        this.applet.show();
                        this.setDefaultFocus();
                        this.status = 3;
                        this.showAppletStatus("started");
                        break;
                    }
                    case 4: {
                        if (this.status != 3) {
                            this.showAppletStatus("notstarted");
                            break;
                        }
                        this.status = 2;
                        this.applet.hide();
                        this.applet.stop();
                        this.showAppletStatus("stopped");
                        break;
                    }
                    case 5: {
                        if (this.status != 2) {
                            this.showAppletStatus("notstopped");
                            break;
                        }
                        this.status = 1;
                        this.applet.destroy();
                        this.showAppletStatus("destroyed");
                        break;
                    }
                    case 0: {
                        if (this.status != 1) {
                            this.showAppletStatus("notdestroyed");
                            break;
                        }
                        this.status = 0;
                        this.remove(this.applet);
                        this.applet = null;
                        this.showAppletStatus("disposed");
                        bl = true;
                        break;
                    }
                    case 6: {
                        return;
                    }
                }
            }
            catch (Exception exception) {
                if (exception.getMessage() != null) {
                    this.showAppletStatus("exception2", exception.getClass().getName(), exception.getMessage());
                } else {
                    this.showAppletStatus("exception", exception.getClass().getName());
                }
                this.showAppletException(exception);
            }
            catch (ThreadDeath threadDeath) {
                this.showAppletStatus("death");
                return;
            }
            catch (Error error) {
                if (error.getMessage() != null) {
                    this.showAppletStatus("error2", error.getClass().getName(), error.getMessage());
                } else {
                    this.showAppletStatus("error", error.getClass().getName());
                }
                this.showAppletException(error);
            }
            this.clearLoadAbortRequest();
        }
    }

    private void setDefaultFocus() {
        Component component = null;
        Container container = this.getParent();
        if (container != null) {
            if (container instanceof Window) {
                component = container.getFocusTraversalPolicy().getInitialComponent((Window)container);
            } else if (container.isFocusCycleRoot()) {
                component = container.getFocusTraversalPolicy().getDefaultComponent(container);
            }
        }
        if (component != null) {
            component.requestFocusInWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLoader() {
        if (this.status != 0) {
            this.showAppletStatus("notdisposed");
            return;
        }
        this.dispatchAppletEvent(51235, null);
        this.status = 1;
        this.loader = this.getClassLoader(this.getCodeBase(), this.getClassLoaderCacheKey());
        String string = this.getCode();
        try {
            try {
                this.loadJarFiles(this.loader);
                this.applet = this.createApplet(this.loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.status = 7;
                this.showAppletStatus("notfound", string);
                this.showAppletLog("notfound", string);
                this.showAppletException(classNotFoundException);
                Object var9_3 = null;
                this.dispatchAppletEvent(51236, null);
                return;
            }
            catch (InstantiationException instantiationException) {
                this.status = 7;
                this.showAppletStatus("nocreate", string);
                this.showAppletLog("nocreate", string);
                this.showAppletException(instantiationException);
                Object var9_4 = null;
                this.dispatchAppletEvent(51236, null);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.status = 7;
                this.showAppletStatus("noconstruct", string);
                this.showAppletLog("noconstruct", string);
                this.showAppletException(illegalAccessException);
                Object var9_5 = null;
                this.dispatchAppletEvent(51236, null);
                return;
            }
            catch (Exception exception) {
                this.status = 7;
                this.showAppletStatus("exception", exception.getMessage());
                this.showAppletException(exception);
                Object var9_6 = null;
                this.dispatchAppletEvent(51236, null);
                return;
            }
            catch (ThreadDeath threadDeath) {
                this.status = 7;
                this.showAppletStatus("death");
                Object var9_7 = null;
                this.dispatchAppletEvent(51236, null);
                return;
            }
            catch (Error error) {
                this.status = 7;
                this.showAppletStatus("error", error.getMessage());
                this.showAppletException(error);
                Object var9_8 = null;
                this.dispatchAppletEvent(51236, null);
                return;
            }
            Object var9_2 = null;
            this.dispatchAppletEvent(51236, null);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.dispatchAppletEvent(51236, null);
            throw throwable;
        }
        if (this.applet != null) {
            this.applet.setStub(this);
            this.applet.hide();
            this.add("Center", this.applet);
            this.showAppletStatus("loaded");
            this.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Applet createApplet(final AppletClassLoader appletClassLoader) throws ClassNotFoundException, IllegalAccessException, IOException, InstantiationException, InterruptedException {
        Object object;
        final String string = this.getSerializedObject();
        String string2 = this.getCode();
        if (string2 != null && string != null) {
            System.err.println(amh.getMessage("runloader.err"));
            throw new InstantiationException("Either \"code\" or \"object\" should be specified, but not both.");
        }
        if (string2 == null && string == null) {
            object = "nocode";
            this.status = 7;
            this.showAppletStatus((String)object);
            this.showAppletLog((String)object);
            this.repaint();
        }
        if (string2 != null) {
            this.applet = (Applet)appletClassLoader.loadCode(string2).newInstance();
            this.doInit = true;
        } else {
            object = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return appletClassLoader.getResourceAsStream(string);
                }
            });
            AppletObjectInputStream appletObjectInputStream = new AppletObjectInputStream((InputStream)object, appletClassLoader);
            Object object2 = appletObjectInputStream.readObject();
            this.applet = (Applet)object2;
            this.doInit = false;
        }
        if (Thread.interrupted()) {
            try {
                this.status = 0;
                this.applet = null;
                this.showAppletStatus("death");
                Object var8_7 = null;
                Thread.currentThread().interrupt();
                return null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.applet;
    }

    protected void loadJarFiles(AppletClassLoader appletClassLoader) throws IOException, InterruptedException {
        String string = this.getJarFiles();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                try {
                    appletClassLoader.addJar(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    protected synchronized void stopLoading() {
        if (this.loaderThread != null) {
            this.loaderThread.interrupt();
        } else {
            this.setLoadAbortRequest();
        }
    }

    protected synchronized boolean okToLoad() {
        return !this.loadAbortRequest;
    }

    protected synchronized void clearLoadAbortRequest() {
        this.loadAbortRequest = false;
    }

    protected synchronized void setLoadAbortRequest() {
        this.loadAbortRequest = true;
    }

    private synchronized void setLoaderThread(Thread thread) {
        this.loaderThread = thread;
    }

    public boolean isActive() {
        return this.status == 3;
    }

    public void appletResize(int n, int n2) {
        this.currentAppletSize.width = n;
        this.currentAppletSize.height = n2;
        Dimension dimension = new Dimension(this.currentAppletSize.width, this.currentAppletSize.height);
        this.dispatchAppletEvent(51234, dimension);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.currentAppletSize.width = n3;
        this.currentAppletSize.height = n4;
    }

    public Applet getApplet() {
        return this.applet;
    }

    protected void showAppletStatus(String string) {
        this.getAppletContext().showStatus(amh.getMessage(string));
    }

    protected void showAppletStatus(String string, Object object) {
        this.getAppletContext().showStatus(amh.getMessage(string, object));
    }

    protected void showAppletStatus(String string, Object object, Object object2) {
        this.getAppletContext().showStatus(amh.getMessage(string, object, object2));
    }

    protected void showAppletLog(String string) {
        System.out.println(amh.getMessage(string));
    }

    protected void showAppletLog(String string, Object object) {
        System.out.println(amh.getMessage(string, object));
    }

    protected void showAppletException(Throwable throwable) {
        throwable.printStackTrace();
        this.repaint();
    }

    public String getClassLoaderCacheKey() {
        return this.getCodeBase().toString();
    }

    public static synchronized void flushClassLoader(String string) {
        classloaders.remove(string);
    }

    public static synchronized void flushClassLoaders() {
        classloaders = new Hashtable();
    }

    protected AppletClassLoader createClassLoader(URL uRL) {
        return new AppletClassLoader(uRL);
    }

    synchronized AppletClassLoader getClassLoader(final URL uRL, final String string) {
        AppletClassLoader appletClassLoader = (AppletClassLoader)classloaders.get(string);
        if (appletClassLoader == null) {
            AccessControlContext accessControlContext = this.getAccessControlContext(uRL);
            appletClassLoader = (AppletClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    AppletClassLoader appletClassLoader = AppletPanel.this.createClassLoader(uRL);
                    Class<?> clazz = this.getClass();
                    synchronized (clazz) {
                        AppletClassLoader appletClassLoader2;
                        block4: {
                            appletClassLoader2 = (AppletClassLoader)classloaders.get(string);
                            if (appletClassLoader2 != null) break block4;
                            classloaders.put(string, appletClassLoader);
                            AppletClassLoader appletClassLoader3 = appletClassLoader;
                            return appletClassLoader3;
                        }
                        AppletClassLoader appletClassLoader4 = appletClassLoader2;
                        return appletClassLoader4;
                    }
                }
            }, accessControlContext);
        }
        return appletClassLoader;
    }

    private AccessControlContext getAccessControlContext(URL uRL) {
        Object object;
        Permission permission;
        PermissionCollection permissionCollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Policy policy = Policy.getPolicy();
                if (policy != null) {
                    return policy.getPermissions(new CodeSource(null, null));
                }
                return null;
            }
        });
        if (permissionCollection == null) {
            permissionCollection = new Permissions();
        }
        permissionCollection.add(new RuntimePermission("createClassLoader"));
        try {
            permission = uRL.openConnection().getPermission();
        }
        catch (IOException iOException) {
            permission = null;
        }
        if (permission instanceof FilePermission) {
            object = permission.getName();
            int n = ((String)object).lastIndexOf(File.separatorChar);
            permissionCollection.add(permission);
            if (n != -1) {
                if (((String)(object = ((String)object).substring(0, n + 1))).endsWith(File.separator)) {
                    object = (String)object + "-";
                }
                permissionCollection.add(new FilePermission((String)object, "read"));
            }
        } else {
            object = uRL.getHost();
            if (object == null) {
                object = "localhost";
            }
            permissionCollection.add(new SocketPermission((String)object, "connect, accept"));
            if (permission != null) {
                permissionCollection.add(permission);
            }
        }
        object = new ProtectionDomain(new CodeSource(uRL, null), permissionCollection);
        AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{object});
        return accessControlContext;
    }

    public Thread getAppletHandlerThread() {
        return this.handler;
    }

    public int getAppletWidth() {
        return this.currentAppletSize.width;
    }

    public int getAppletHeight() {
        return this.currentAppletSize.height;
    }
}

