/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.LocalVariableImpl;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ThreadAction;
import com.sun.tools.jdi.ThreadListener;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.VMState;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StackFrameImpl
extends MirrorImpl
implements StackFrame,
ThreadListener {
    private boolean isValid = true;
    private final ThreadReferenceImpl thread;
    private final long id;
    private final Location location;
    private Map visibleVariables = null;
    private ObjectReference thisObject = null;

    StackFrameImpl(VirtualMachine virtualMachine, ThreadReferenceImpl threadReferenceImpl, long l, Location location) {
        super(virtualMachine);
        this.thread = threadReferenceImpl;
        this.id = l;
        this.location = location;
        threadReferenceImpl.addListener(this);
    }

    public boolean threadResumable(ThreadAction threadAction) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            block4: {
                if (!this.isValid) break block4;
                this.isValid = false;
                boolean bl = false;
                return bl;
            }
            throw new InternalException("Invalid stack frame thread listener");
        }
    }

    private void validateStackFrame() {
        if (!this.isValid) {
            throw new InvalidStackFrameException("Thread has been resumed");
        }
    }

    public Location location() {
        this.validateStackFrame();
        return this.location;
    }

    public ThreadReference thread() {
        this.validateStackFrame();
        return this.thread;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof StackFrameImpl) {
            StackFrameImpl stackFrameImpl = (StackFrameImpl)object;
            return this.id == stackFrameImpl.id && this.thread().equals(stackFrameImpl.thread()) && this.location().equals(stackFrameImpl.location()) && super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return (this.thread().hashCode() << 4) + (int)this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectReference thisObject() {
        this.validateStackFrame();
        MethodImpl methodImpl = (MethodImpl)this.location.method();
        if (methodImpl.isStatic() || methodImpl.isNative()) {
            return null;
        }
        if (this.thisObject == null) {
            PacketStream packetStream;
            VMState vMState = this.vm.state();
            synchronized (vMState) {
                this.validateStackFrame();
                packetStream = JDWP.StackFrame.ThisObject.enqueueCommand(this.vm, this.thread, this.id);
            }
            try {
                this.thisObject = JDWP.StackFrame.ThisObject.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)packetStream).objectThis;
            }
            catch (JDWPException jDWPException) {
                switch (jDWPException.errorCode()) {
                    case 10: 
                    case 13: 
                    case 30: {
                        throw new InvalidStackFrameException();
                    }
                }
                throw jDWPException.toJDIException();
            }
        }
        return this.thisObject;
    }

    private void createVisibleVariables() throws AbsentInformationException {
        if (this.visibleVariables == null) {
            List list = this.location.method().variables();
            HashMap<String, LocalVariableImpl> hashMap = new HashMap<String, LocalVariableImpl>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LocalVariable localVariable;
                LocalVariableImpl localVariableImpl = (LocalVariableImpl)iterator.next();
                String string = localVariableImpl.name();
                if (!localVariableImpl.isVisible(this) || (localVariable = (LocalVariable)hashMap.get(string)) != null && !localVariableImpl.hides(localVariable)) continue;
                hashMap.put(string, localVariableImpl);
            }
            this.visibleVariables = hashMap;
        }
    }

    public List visibleVariables() throws AbsentInformationException {
        this.validateStackFrame();
        this.createVisibleVariables();
        ArrayList arrayList = new ArrayList(this.visibleVariables.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    public LocalVariable visibleVariableByName(String string) throws AbsentInformationException {
        this.validateStackFrame();
        this.createVisibleVariables();
        return (LocalVariable)this.visibleVariables.get(string);
    }

    public Value getValue(LocalVariable localVariable) {
        ArrayList<LocalVariable> arrayList = new ArrayList<LocalVariable>(1);
        arrayList.add(localVariable);
        Map map = this.getValues(arrayList);
        return (Value)map.get(localVariable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getValues(List list) {
        ValueImpl[] valueImplArray;
        Object object;
        this.validateStackFrame();
        this.validateMirrors(list);
        int n = list.size();
        JDWP.StackFrame.GetValues.SlotInfo[] slotInfoArray = new JDWP.StackFrame.GetValues.SlotInfo[n];
        int n2 = 0;
        while (n2 < n) {
            object = (LocalVariableImpl)list.get(n2);
            if (!((LocalVariableImpl)object).isVisible(this)) {
                throw new IllegalArgumentException(((LocalVariableImpl)object).name() + " is not valid at this frame location");
            }
            slotInfoArray[n2] = new JDWP.StackFrame.GetValues.SlotInfo(((LocalVariableImpl)object).slot(), (byte)((LocalVariableImpl)object).signature().charAt(0));
            ++n2;
        }
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.validateStackFrame();
            object = JDWP.StackFrame.GetValues.enqueueCommand(this.vm, this.thread, this.id, slotInfoArray);
        }
        try {
            valueImplArray = JDWP.StackFrame.GetValues.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)object).values;
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 10: 
                case 13: 
                case 30: {
                    throw new InvalidStackFrameException();
                }
            }
            throw jDWPException.toJDIException();
        }
        if (n != valueImplArray.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        HashMap<LocalVariableImpl, ValueImpl> hashMap = new HashMap<LocalVariableImpl, ValueImpl>(n);
        int n3 = 0;
        while (n3 < n) {
            LocalVariableImpl localVariableImpl = (LocalVariableImpl)list.get(n3);
            hashMap.put(localVariableImpl, valueImplArray[n3]);
            ++n3;
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(LocalVariable localVariable, Value value) throws InvalidTypeException, ClassNotLoadedException {
        block11: {
            this.validateStackFrame();
            this.validateMirror(localVariable);
            this.validateMirrorOrNull(value);
            LocalVariableImpl localVariableImpl = (LocalVariableImpl)localVariable;
            ValueImpl valueImpl = (ValueImpl)value;
            if (!localVariableImpl.isVisible(this)) {
                throw new IllegalArgumentException(localVariableImpl.name() + " is not valid at this frame location");
            }
            try {
                PacketStream packetStream;
                valueImpl = ValueImpl.prepareForAssignment(valueImpl, localVariableImpl);
                JDWP.StackFrame.SetValues.SlotInfo[] slotInfoArray = new JDWP.StackFrame.SetValues.SlotInfo[]{new JDWP.StackFrame.SetValues.SlotInfo(localVariableImpl.slot(), valueImpl)};
                VMState vMState = this.vm.state();
                synchronized (vMState) {
                    this.validateStackFrame();
                    packetStream = JDWP.StackFrame.SetValues.enqueueCommand(this.vm, this.thread, this.id, slotInfoArray);
                }
                try {
                    JDWP.StackFrame.SetValues.waitForReply(this.vm, packetStream);
                }
                catch (JDWPException jDWPException) {
                    switch (jDWPException.errorCode()) {
                        case 10: 
                        case 13: 
                        case 30: {
                            throw new InvalidStackFrameException();
                        }
                    }
                    throw jDWPException.toJDIException();
                }
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                if (valueImpl == null) break block11;
                throw classNotLoadedException;
            }
        }
    }

    void pop() throws IncompatibleThreadStateException {
        this.validateStackFrame();
        CommandSender commandSender = new CommandSender(){

            public PacketStream send() {
                return JDWP.StackFrame.PopFrames.enqueueCommand(StackFrameImpl.this.vm, StackFrameImpl.this.thread, StackFrameImpl.this.id);
            }
        };
        try {
            PacketStream packetStream = this.thread.sendResumingCommand(commandSender);
            JDWP.StackFrame.PopFrames.waitForReply(this.vm, packetStream);
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 13: {
                    throw new IncompatibleThreadStateException("Thread not current or suspended");
                }
                case 10: {
                    throw new IncompatibleThreadStateException("zombie");
                }
                case 31: {
                    throw new InvalidStackFrameException("No more frames on the stack");
                }
            }
            throw jDWPException.toJDIException();
        }
        this.vm.state().freeze();
    }

    public String toString() {
        return this.location.toString() + " in thread " + this.thread.toString();
    }
}

