/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.ClassLoaderReferenceImpl;
import com.sun.tools.jdi.FieldImpl;
import com.sun.tools.jdi.InterfaceTypeImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.ObsoleteMethodImpl;
import com.sun.tools.jdi.SDE;
import com.sun.tools.jdi.TypeComponentImpl;
import com.sun.tools.jdi.TypeImpl;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ReferenceTypeImpl
extends TypeImpl
implements ReferenceType {
    protected long ref;
    private String signature = null;
    private boolean isSourceNameCached = false;
    private String baseSourceName = null;
    private String baseSourceDir = null;
    private String baseSourcePath = null;
    protected int modifiers = -1;
    private SoftReference fieldsRef = null;
    private SoftReference methodsRef = null;
    private SoftReference sdeRef = null;
    private boolean isClassLoaderCached;
    private ClassLoaderReference classLoader = null;
    private ClassObjectReference classObject = null;
    private int status = -1;
    private boolean isPrepared = false;
    static final SDE NO_SDE_INFO_MARK = new SDE();
    private static final int INITIALIZED_OR_FAILED = 12;

    protected ReferenceTypeImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine);
        this.ref = l;
    }

    Method getMethodMirror(long l) {
        if (l == 0L) {
            return new ObsoleteMethodImpl(this.vm, this);
        }
        Iterator iterator = this.methods().iterator();
        while (iterator.hasNext()) {
            MethodImpl methodImpl = (MethodImpl)iterator.next();
            if (methodImpl.ref() != l) continue;
            return methodImpl;
        }
        throw new IllegalArgumentException("Invalid method id: " + l);
    }

    Field getFieldMirror(long l) {
        Iterator iterator = this.fields().iterator();
        while (iterator.hasNext()) {
            FieldImpl fieldImpl = (FieldImpl)iterator.next();
            if (fieldImpl.ref() != l) continue;
            return fieldImpl;
        }
        throw new IllegalArgumentException("Invalid field id: " + l);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ReferenceTypeImpl) {
            ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)object;
            return this.ref() == referenceTypeImpl.ref() && this.vm.equals(referenceTypeImpl.virtualMachine());
        }
        return false;
    }

    public int hashCode() {
        return (int)this.ref();
    }

    public int compareTo(Object object) {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)object;
        int n = this.name().compareTo(referenceTypeImpl.name());
        if (n == 0) {
            long l;
            long l2 = this.ref();
            n = l2 == (l = referenceTypeImpl.ref()) ? this.vm.sequenceNumber - ((VirtualMachineImpl)referenceTypeImpl.virtualMachine()).sequenceNumber : (l2 < l ? -1 : 1);
        }
        return n;
    }

    public String signature() {
        if (this.signature == null) {
            try {
                this.signature = JDWP.ReferenceType.Signature.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).signature;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.signature;
    }

    public ClassLoaderReference classLoader() {
        if (!this.isClassLoaderCached) {
            try {
                this.classLoader = JDWP.ReferenceType.ClassLoader.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).classLoader;
                this.isClassLoaderCached = true;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.classLoader;
    }

    public boolean isPublic() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 1) > 0;
    }

    public boolean isProtected() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 4) > 0;
    }

    public boolean isPrivate() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 2) > 0;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isAbstract() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 0x400) > 0;
    }

    public boolean isFinal() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 0x10) > 0;
    }

    public boolean isStatic() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 8) > 0;
    }

    public boolean isPrepared() {
        if (this.status == -1) {
            this.getModifiers();
        }
        return this.isPrepared;
    }

    public boolean isVerified() {
        if ((this.status & 1) == 0) {
            this.updateStatus();
        }
        return (this.status & 1) != 0;
    }

    public boolean isInitialized() {
        if ((this.status & 0xC) == 0) {
            this.updateStatus();
        }
        return (this.status & 4) != 0;
    }

    public boolean failedToInitialize() {
        if ((this.status & 0xC) == 0) {
            this.updateStatus();
        }
        return (this.status & 8) != 0;
    }

    public List fields() {
        List<FieldImpl> list;
        List list2 = list = this.fieldsRef == null ? null : (ArrayList)this.fieldsRef.get();
        if (list == null) {
            JDWP.ReferenceType.Fields.FieldInfo[] fieldInfoArray;
            try {
                fieldInfoArray = JDWP.ReferenceType.Fields.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).declared;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
            list = new ArrayList(fieldInfoArray.length);
            int n = 0;
            while (n < fieldInfoArray.length) {
                JDWP.ReferenceType.Fields.FieldInfo fieldInfo = fieldInfoArray[n];
                FieldImpl fieldImpl = new FieldImpl(this.vm, this, fieldInfo.fieldID, fieldInfo.name, fieldInfo.signature, fieldInfo.modBits);
                list.add(fieldImpl);
                ++n;
            }
            list = Collections.unmodifiableList(list);
            this.fieldsRef = new SoftReference(list);
        }
        return list;
    }

    abstract List inheritedTypes();

    void addVisibleFields(List list, Map map, List list2) {
        List list3 = this.visibleFields();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            String string = field.name();
            if (list2.contains(string)) continue;
            Field field2 = (Field)map.get(string);
            if (field2 == null) {
                list.add(field);
                map.put(string, field);
                continue;
            }
            if (field.equals(field2)) continue;
            list2.add(string);
            map.remove(string);
            list.remove(field2);
        }
    }

    public List visibleFields() {
        Object object;
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        ArrayList arrayList2 = new ArrayList();
        List list = this.inheritedTypes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (ReferenceTypeImpl)iterator.next();
            ((ReferenceTypeImpl)object).addVisibleFields(arrayList, hashMap, arrayList2);
        }
        object = new ArrayList(this.fields());
        iterator = object.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            Field field2 = (Field)hashMap.get(field.name());
            if (field2 == null) continue;
            arrayList.remove(field2);
        }
        object.addAll(arrayList);
        return object;
    }

    void addAllFields(List list, Set set) {
        if (!set.contains(this)) {
            set.add(this);
            list.addAll(this.fields());
            List list2 = this.inheritedTypes();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)iterator.next();
                referenceTypeImpl.addAllFields(list, set);
            }
        }
    }

    public List allFields() {
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        this.addAllFields(arrayList, hashSet);
        return arrayList;
    }

    public Field fieldByName(String string) {
        List list = this.visibleFields();
        int n = 0;
        while (n < list.size()) {
            Field field = (Field)list.get(n);
            if (field.name().equals(string)) {
                return field;
            }
            ++n;
        }
        return null;
    }

    public List methods() {
        List<MethodImpl> list;
        List list2 = list = this.methodsRef == null ? null : (ArrayList)this.methodsRef.get();
        if (list == null) {
            JDWP.ReferenceType.Methods.MethodInfo[] methodInfoArray;
            try {
                methodInfoArray = JDWP.ReferenceType.Methods.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).declared;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
            list = new ArrayList(methodInfoArray.length);
            int n = 0;
            while (n < methodInfoArray.length) {
                JDWP.ReferenceType.Methods.MethodInfo methodInfo = methodInfoArray[n];
                MethodImpl methodImpl = MethodImpl.createMethodImpl(this.vm, this, methodInfo.methodID, methodInfo.name, methodInfo.signature, methodInfo.modBits);
                list.add(methodImpl);
                ++n;
            }
            list = Collections.unmodifiableList(list);
            this.methodsRef = new SoftReference(list);
        }
        return list;
    }

    void addToMethodMap(Map map, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            map.put(method.name().concat(method.signature()), method);
        }
    }

    abstract void addVisibleMethods(Map var1);

    public List visibleMethods() {
        HashMap hashMap = new HashMap();
        this.addVisibleMethods(hashMap);
        List list = this.allMethods();
        list.retainAll(hashMap.values());
        return list;
    }

    public abstract List allMethods();

    public List methodsByName(String string) {
        List list = this.visibleMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!method.name().equals(string)) continue;
            arrayList.add(method);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public List methodsByName(String string, String string2) {
        List list = this.visibleMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!method.name().equals(string) || !method.signature().equals(string2)) continue;
            arrayList.add(method);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    List getInterfaces() {
        InterfaceTypeImpl[] interfaceTypeImplArray;
        try {
            interfaceTypeImplArray = JDWP.ReferenceType.Interfaces.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).interfaces;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return Arrays.asList(interfaceTypeImplArray);
    }

    public List nestedTypes() {
        List list = this.vm.allClasses();
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        String string = this.name() + '$';
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ReferenceType referenceType = (ReferenceType)iterator.next();
            if (!referenceType.name().startsWith(string)) continue;
            arrayList.add(referenceType);
        }
        return arrayList;
    }

    public Value getValue(Field field) {
        ArrayList<Field> arrayList = new ArrayList<Field>(1);
        arrayList.add(field);
        Map map = this.getValues(arrayList);
        return (Value)map.get(field);
    }

    void validateFieldAccess(Field field) {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)field.declaringType();
        if (!referenceTypeImpl.isAssignableFrom(this)) {
            throw new IllegalArgumentException("Invalid field");
        }
    }

    void validateFieldSet(Field field) {
        this.validateFieldAccess(field);
        if (field.isFinal()) {
            throw new IllegalArgumentException("Cannot set value of static final field");
        }
    }

    public Map getValues(List list) {
        ValueImpl[] valueImplArray;
        Object object;
        this.validateMirrors(list);
        int n = list.size();
        JDWP.ReferenceType.GetValues.Field[] fieldArray = new JDWP.ReferenceType.GetValues.Field[n];
        int n2 = 0;
        while (n2 < n) {
            object = (FieldImpl)list.get(n2);
            this.validateFieldAccess((Field)object);
            if (!((TypeComponentImpl)object).isStatic()) {
                throw new IllegalArgumentException("Attempt to use non-static field with ReferenceType");
            }
            fieldArray[n2] = new JDWP.ReferenceType.GetValues.Field(((TypeComponentImpl)object).ref());
            ++n2;
        }
        object = new HashMap(n);
        try {
            valueImplArray = JDWP.ReferenceType.GetValues.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this, (JDWP.ReferenceType.GetValues.Field[])fieldArray).values;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        if (n != valueImplArray.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        int n3 = 0;
        while (n3 < n) {
            FieldImpl fieldImpl = (FieldImpl)list.get(n3);
            object.put(fieldImpl, valueImplArray[n3]);
            ++n3;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassObjectReference classObject() {
        if (this.classObject == null) {
            ReferenceTypeImpl referenceTypeImpl = this;
            synchronized (referenceTypeImpl) {
                if (this.classObject == null) {
                    try {
                        this.classObject = JDWP.ReferenceType.ClassObject.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).classObject;
                    }
                    catch (JDWPException jDWPException) {
                        throw jDWPException.toJDIException();
                    }
                }
            }
        }
        return this.classObject;
    }

    SDE.Stratum stratum(String string) {
        SDE sDE = this.sourceDebugExtensionInfo();
        if (!sDE.isValid()) {
            sDE = NO_SDE_INFO_MARK;
        }
        return sDE.stratum(string);
    }

    public String sourceName() throws AbsentInformationException {
        return (String)this.sourceNames(this.vm.getDefaultStratum()).get(0);
    }

    public List sourceNames(String string) throws AbsentInformationException {
        SDE.Stratum stratum = this.stratum(string);
        if (stratum.isJava()) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(this.baseSourceName());
            return arrayList;
        }
        return stratum.sourceNames(this);
    }

    public List sourcePaths(String string) throws AbsentInformationException {
        SDE.Stratum stratum = this.stratum(string);
        if (stratum.isJava()) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(this.baseSourceDir() + this.baseSourceName());
            return arrayList;
        }
        return stratum.sourcePaths(this);
    }

    String baseSourceName() throws AbsentInformationException {
        if (!this.isSourceNameCached) {
            try {
                this.baseSourceName = JDWP.ReferenceType.SourceFile.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).sourceFile;
                this.isSourceNameCached = true;
            }
            catch (JDWPException jDWPException) {
                if (jDWPException.errorCode() == 101) {
                    this.isSourceNameCached = true;
                    throw new AbsentInformationException();
                }
                throw jDWPException.toJDIException();
            }
        }
        if (this.baseSourceName == null) {
            throw new AbsentInformationException();
        }
        return this.baseSourceName;
    }

    String baseSourcePath() throws AbsentInformationException {
        if (this.baseSourcePath == null) {
            this.baseSourcePath = this.baseSourceDir() + this.baseSourceName();
        }
        return this.baseSourcePath;
    }

    String baseSourceDir() {
        if (this.baseSourceDir == null) {
            int n;
            String string = this.name();
            StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
            int n2 = 0;
            while ((n = string.indexOf(46, n2)) > 0) {
                stringBuffer.append(string.substring(n2, n));
                stringBuffer.append(File.separatorChar);
                n2 = n + 1;
            }
            this.baseSourceDir = stringBuffer.toString();
        }
        return this.baseSourceDir;
    }

    public String sourceDebugExtension() throws AbsentInformationException {
        if (!this.vm.canGetSourceDebugExtension()) {
            throw new UnsupportedOperationException();
        }
        SDE sDE = this.sourceDebugExtensionInfo();
        if (sDE == NO_SDE_INFO_MARK) {
            throw new AbsentInformationException();
        }
        return sDE.sourceDebugExtension;
    }

    private SDE sourceDebugExtensionInfo() {
        SDE sDE;
        if (!this.vm.canGetSourceDebugExtension()) {
            return NO_SDE_INFO_MARK;
        }
        SDE sDE2 = sDE = this.sdeRef == null ? null : (SDE)this.sdeRef.get();
        if (sDE == null) {
            String string;
            block4: {
                string = null;
                try {
                    string = JDWP.ReferenceType.SourceDebugExtension.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).extension;
                }
                catch (JDWPException jDWPException) {
                    if (jDWPException.errorCode() == 101) break block4;
                    this.sdeRef = new SoftReference<SDE>(NO_SDE_INFO_MARK);
                    throw jDWPException.toJDIException();
                }
            }
            sDE = string == null ? NO_SDE_INFO_MARK : new SDE(string);
            this.sdeRef = new SoftReference<SDE>(sDE);
        }
        return sDE;
    }

    public List availableStrata() {
        SDE sDE = this.sourceDebugExtensionInfo();
        if (sDE.isValid()) {
            return sDE.availableStrata();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Java");
        return arrayList;
    }

    public String defaultStratum() {
        SDE sDE = this.sourceDebugExtensionInfo();
        if (sDE.isValid()) {
            return sDE.defaultStratumId;
        }
        return "Java";
    }

    public int modifiers() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return this.modifiers;
    }

    public List allLineLocations() throws AbsentInformationException {
        return this.allLineLocations(this.vm.getDefaultStratum(), null);
    }

    public List allLineLocations(String string, String string2) throws AbsentInformationException {
        boolean bl = false;
        SDE.Stratum stratum = this.stratum(string);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.methods().iterator();
        while (iterator.hasNext()) {
            MethodImpl methodImpl = (MethodImpl)iterator.next();
            try {
                arrayList.addAll(methodImpl.allLineLocations(stratum, string2));
            }
            catch (AbsentInformationException absentInformationException) {
                bl = true;
            }
        }
        if (bl && arrayList.size() == 0) {
            throw new AbsentInformationException();
        }
        return arrayList;
    }

    public List locationsOfLine(int n) throws AbsentInformationException {
        return this.locationsOfLine(this.vm.getDefaultStratum(), null, n);
    }

    public List locationsOfLine(String string, String string2, int n) throws AbsentInformationException {
        boolean bl = false;
        boolean bl2 = false;
        List list = this.methods();
        SDE.Stratum stratum = this.stratum(string);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MethodImpl methodImpl = (MethodImpl)iterator.next();
            if (methodImpl.isAbstract() || methodImpl.isNative()) continue;
            try {
                arrayList.addAll(methodImpl.locationsOfLine(stratum, string2, n));
                bl2 = true;
            }
            catch (AbsentInformationException absentInformationException) {
                bl = true;
            }
        }
        if (bl && !bl2) {
            throw new AbsentInformationException();
        }
        return arrayList;
    }

    void getModifiers() {
        if (this.modifiers != -1) {
            return;
        }
        try {
            this.modifiers = JDWP.ReferenceType.Modifiers.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).modBits;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    void decodeStatus(int n) {
        this.status = n;
        if ((n & 2) != 0) {
            this.isPrepared = true;
        }
    }

    void updateStatus() {
        try {
            this.decodeStatus(JDWP.ReferenceType.Status.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).status);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    void markPrepared() {
        this.isPrepared = true;
    }

    long ref() {
        return this.ref;
    }

    int indexOf(Method method) {
        return this.methods().indexOf(method);
    }

    int indexOf(Field field) {
        return this.fields().indexOf(field);
    }

    abstract boolean isAssignableTo(ReferenceType var1);

    boolean isAssignableFrom(ReferenceType referenceType) {
        return ((ReferenceTypeImpl)referenceType).isAssignableTo(this);
    }

    boolean isAssignableFrom(ObjectReference objectReference) {
        return objectReference == null || this.isAssignableFrom(objectReference.referenceType());
    }

    void setStatus(int n) {
        this.decodeStatus(n);
    }

    void setSignature(String string) {
        this.signature = string;
    }

    private static boolean isPrimitiveArray(String string) {
        char c;
        int n = string.lastIndexOf(91);
        boolean bl = n < 0 ? false : (c = string.charAt(n + 1)) != 'L';
        return bl;
    }

    Type findType(String string) throws ClassNotLoadedException {
        ClassLoaderReferenceImpl classLoaderReferenceImpl;
        char c;
        Type type = string.length() == 1 ? ((c = string.charAt(0)) == 'V' ? this.vm.theVoidType() : this.vm.primitiveTypeMirror((byte)c)) : ((classLoaderReferenceImpl = (ClassLoaderReferenceImpl)this.classLoader()) == null || ReferenceTypeImpl.isPrimitiveArray(string) ? this.vm.findBootType(string) : classLoaderReferenceImpl.findType(string));
        return type;
    }

    String loaderString() {
        if (this.classLoader() != null) {
            return "loaded by " + this.classLoader().toString();
        }
        return "no class loader";
    }
}

