/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.InternalException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.Transport;
import com.sun.jdi.connect.VMStartException;
import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.ConnectorImpl;
import com.sun.tools.jdi.TransportService;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

abstract class AbstractLauncher
extends ConnectorImpl
implements LaunchingConnector {
    private TransportService transport;

    AbstractLauncher(VirtualMachineManagerService virtualMachineManagerService, TransportService transportService) {
        super(virtualMachineManagerService);
        this.transport = transportService;
    }

    public abstract VirtualMachine launch(Map var1) throws IOException, IllegalConnectorArgumentsException, VMStartException;

    public abstract String name();

    public abstract String description();

    String[] tokenizeCommand(String string, char c) {
        String[] stringArray;
        String string2 = String.valueOf(c);
        StringTokenizer stringTokenizer = new StringTokenizer(string, c + " \t\r\n\f", true);
        Object object = null;
        String[] stringArray2 = null;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (object != null) {
                if (stringArray.equals(string2)) {
                    arrayList.add((String[])object);
                    object = null;
                    continue;
                }
                object = (String)object + (String)stringArray;
                continue;
            }
            if (stringArray2 != null) {
                if (stringArray.equals(string2)) {
                    object = stringArray2;
                } else if (stringArray.length() == 1 && Character.isWhitespace(stringArray.charAt(0))) {
                    arrayList.add(stringArray2);
                } else {
                    throw new InternalException("Unexpected token: " + (String)stringArray);
                }
                stringArray2 = null;
                continue;
            }
            if (stringArray.equals(string2)) {
                object = "";
                continue;
            }
            if (stringArray.length() == 1 && Character.isWhitespace(stringArray.charAt(0))) continue;
            stringArray2 = stringArray;
        }
        if (stringArray2 != null) {
            arrayList.add(stringArray2);
        }
        if (object != null) {
            arrayList.add((String[])object);
        }
        stringArray = new String[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            stringArray[n] = (String)arrayList.get(n);
            ++n;
        }
        return stringArray;
    }

    protected VirtualMachine launch(String[] stringArray, String string) throws IOException, VMStartException {
        Helper helper = new Helper(stringArray, string);
        helper.launchAndAccept();
        return this.manager().createVirtualMachine(helper.connection(), helper.process());
    }

    public Transport transport() {
        return this.transport;
    }

    protected TransportService transportService() {
        return this.transport;
    }

    static /* synthetic */ TransportService access$300(AbstractLauncher abstractLauncher) {
        return abstractLauncher.transport;
    }

    private class Helper {
        private final String address;
        private final String[] commandArray;
        private Process process = null;
        private ConnectionService connection = null;
        private IOException acceptException = null;
        private boolean exited = false;

        Helper(String[] stringArray, String string) {
            this.commandArray = stringArray;
            this.address = string;
        }

        String commandString() {
            String string = "";
            int n = 0;
            while (n < this.commandArray.length) {
                if (n > 0) {
                    string = string + " ";
                }
                string = string + this.commandArray[n];
                ++n;
            }
            return string;
        }

        synchronized void launchAndAccept() throws IOException, VMStartException {
            this.process = Runtime.getRuntime().exec(this.commandArray);
            Thread thread = this.acceptConnection();
            Thread thread2 = this.monitorTarget();
            try {
                try {
                    while (this.connection == null && this.acceptException == null && !this.exited) {
                        this.wait();
                    }
                    if (this.exited) {
                        throw new VMStartException("VM initialization failed for: " + this.commandString(), this.process);
                    }
                    if (this.acceptException != null) {
                        throw this.acceptException;
                    }
                    Object var5_3 = null;
                    thread.interrupt();
                    thread2.interrupt();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException("Interrupted during accept");
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                thread.interrupt();
                thread2.interrupt();
                throw throwable;
            }
        }

        Process process() {
            return this.process;
        }

        ConnectionService connection() {
            return this.connection;
        }

        synchronized void notifyOfExit() {
            this.exited = true;
            this.notify();
        }

        synchronized void notifyOfConnection(ConnectionService connectionService) {
            this.connection = connectionService;
            this.notify();
        }

        synchronized void notifyOfAcceptException(IOException iOException) {
            this.acceptException = iOException;
            this.notify();
        }

        Thread monitorTarget() {
            Thread thread = new Thread(this, AbstractLauncher.this.mainGroupForJDI(), "launched target monitor"){
                private final /* synthetic */ Helper this$1;
                {
                    this.this$1 = helper;
                    super(threadGroup, string);
                }

                public void run() {
                    try {
                        Helper.access$000(this.this$1).waitFor();
                        this.this$1.notifyOfExit();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            return thread;
        }

        Thread acceptConnection() {
            Thread thread = new Thread(this, AbstractLauncher.this.mainGroupForJDI(), "connection acceptor"){
                private final /* synthetic */ Helper this$1;
                {
                    this.this$1 = helper;
                    super(threadGroup, string);
                }

                public void run() {
                    try {
                        ConnectionService connectionService = AbstractLauncher.access$300(Helper.access$200(this.this$1)).accept(Helper.access$100(this.this$1));
                        this.this$1.notifyOfConnection(connectionService);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                    }
                    catch (IOException iOException) {
                        this.this$1.notifyOfAcceptException(iOException);
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            return thread;
        }

        static /* synthetic */ Process access$000(Helper helper) {
            return helper.process;
        }

        static /* synthetic */ String access$100(Helper helper) {
            return helper.address;
        }

        static /* synthetic */ AbstractLauncher access$200(Helper helper) {
            return helper.AbstractLauncher.this;
        }
    }
}

