/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Util {
    public static boolean verbose = false;
    private static ResourceBundle m;
    static ResourceBundle platform;

    public static void log(String string) {
        System.out.println(string);
    }

    private static void initMessages() {
        try {
            m = ResourceBundle.getBundle("com.sun.tools.javah.resources.l10n");
        }
        catch (MissingResourceException missingResourceException) {
            Util.fatal("Error loading resources.  Please file a bug report.", missingResourceException);
        }
    }

    public static String getText(String string) {
        return Util.getText(string, null, null);
    }

    private static String getText(String string, String string2, String string3) {
        if (m == null) {
            Util.initMessages();
        }
        try {
            return MessageFormat.format(m.getString(string), string2, string3);
        }
        catch (MissingResourceException missingResourceException) {
            Util.fatal("Key " + string + " not found in resources.", missingResourceException);
            return null;
        }
    }

    public static void usage(int n) {
        if (n == 0) {
            System.out.println(Util.getText("usage"));
        } else {
            System.err.println(Util.getText("usage"));
        }
        System.exit(n);
    }

    public static void version() {
        System.out.println(Util.getText("javah.version", System.getProperty("java.version"), null));
        System.exit(0);
    }

    public static void bug(String string) {
        Util.bug(string, null);
    }

    public static void bug(String string, Exception exception) {
        if (exception != null) {
            exception.printStackTrace();
        }
        System.err.println(Util.getText(string));
        System.err.println(Util.getText("bug.report"));
        System.exit(11);
    }

    public static void error(String string) {
        Util.error(string, null);
    }

    public static void error(String string, String string2) {
        Util.error(string, string2, null);
    }

    public static void error(String string, String string2, String string3) {
        Util.error(string, string2, string3, false);
    }

    public static void error(String string, String string2, String string3, boolean bl) {
        System.err.println("Error: " + Util.getText(string, string2, string3));
        if (bl) {
            Util.usage(15);
        }
        System.exit(15);
    }

    private static void fatal(String string) {
        Util.fatal(string, null);
    }

    private static void fatal(String string, Exception exception) {
        if (exception != null) {
            exception.printStackTrace();
        }
        System.err.println(string);
        System.exit(10);
    }

    static String getPlatformString(String string) {
        if (platform == null) {
            Util.initPlatform();
        }
        try {
            return platform.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static void initPlatform() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            string = "win32";
        } else if (string.indexOf("Linux") >= 0) {
            string = "Linux";
        }
        String string2 = System.getProperty("os.arch");
        String string3 = "com.sun.tools.javah.resources." + string + "_" + string2;
        try {
            platform = ResourceBundle.getBundle(string3);
        }
        catch (MissingResourceException missingResourceException) {
            Util.fatal("Error loading resources.  Please file a bug report.", missingResourceException);
        }
    }

    static {
        platform = null;
    }
}

