/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Type;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.MemberDocImpl;
import com.sun.tools.javadoc.SourcePositionImpl;
import com.sun.tools.javadoc.TypeMaker;
import java.lang.reflect.Modifier;

public class FieldDocImpl
extends MemberDocImpl
implements FieldDoc {
    protected final Symbol.VarSymbol sym;
    Tree.VarDef tree = null;

    public FieldDocImpl(DocEnv docEnv, Symbol.VarSymbol varSymbol, String string) {
        super(docEnv, string);
        this.sym = varSymbol;
    }

    public FieldDocImpl(DocEnv docEnv, Symbol.VarSymbol varSymbol) {
        this(docEnv, varSymbol, null);
    }

    protected int getFlags() {
        return this.sym.flags();
    }

    protected Symbol.ClassSymbol getContainingClass() {
        return this.sym.enclClass();
    }

    public Type type() {
        return TypeMaker.getType(this.env, this.sym.type);
    }

    public Object constantValue() {
        if (this.sym.constValue != null) {
            this.env.attr.evalInit(this.sym);
        }
        return this.sym.constValue;
    }

    public String constantValueExpression() {
        Object object = this.constantValue();
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return this.sourceForm(((Character)object).charValue());
        }
        if (object instanceof Byte) {
            return this.sourceForm((Byte)object);
        }
        if (object instanceof String) {
            return this.sourceForm((String)object);
        }
        if (object instanceof Double) {
            return this.sourceForm((Double)object, 'd');
        }
        if (object instanceof Float) {
            return this.sourceForm(((Float)object).doubleValue(), 'f');
        }
        if (object instanceof Long) {
            return object + "l";
        }
        return object.toString();
    }

    private String sourceForm(double d, char c) {
        if (Double.isNaN(d)) {
            return "0" + c + "/0" + c;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "1" + c + "/0" + c;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-1" + c + "/0" + c;
        }
        return "" + d + c;
    }

    private String sourceForm(char c) {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append('\'');
        this.sourceChar(c, stringBuffer);
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    private String sourceForm(byte by) {
        return "0x" + Integer.toString(by & 0xFF, 16);
    }

    private String sourceForm(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        stringBuffer.append('\"');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            this.sourceChar(c, stringBuffer);
            ++n;
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private void sourceChar(char c, StringBuffer stringBuffer) {
        switch (c) {
            case '\b': {
                stringBuffer.append("\\b");
                return;
            }
            case '\t': {
                stringBuffer.append("\\t");
                return;
            }
            case '\n': {
                stringBuffer.append("\\n");
                return;
            }
            case '\f': {
                stringBuffer.append("\\f");
                return;
            }
            case '\r': {
                stringBuffer.append("\\r");
                return;
            }
            case '\"': {
                stringBuffer.append("\\\"");
                return;
            }
            case '\'': {
                stringBuffer.append("\\'");
                return;
            }
            case '\\': {
                stringBuffer.append("\\\\");
                return;
            }
        }
        if (this.isPrintableAscii(c)) {
            stringBuffer.append(c);
            return;
        }
        this.unicodeEscape(c, stringBuffer);
    }

    private void unicodeEscape(char c, StringBuffer stringBuffer) {
        stringBuffer.append("\\u");
        stringBuffer.append("0123456789abcdef".charAt(0xF & c >> 12));
        stringBuffer.append("0123456789abcdef".charAt(0xF & c >> 8));
        stringBuffer.append("0123456789abcdef".charAt(0xF & c >> 4));
        stringBuffer.append("0123456789abcdef".charAt(0xF & c >> 0));
    }

    private boolean isPrintableAscii(char c) {
        return c >= ' ' && c <= '~';
    }

    public boolean isIncluded() {
        return this.containingClass().isIncluded();
    }

    public boolean isField() {
        return true;
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    public boolean isSynthetic() {
        return (this.sym.flags() & 0x10000) != 0;
    }

    public SerialFieldTag[] serialFieldTags() {
        return this.comment().serialFieldTags();
    }

    public String name() {
        return this.sym.name.toString();
    }

    public String qualifiedName() {
        return this.sym.enclClass().fullName().toString() + '.' + this.name();
    }

    public SourcePosition position() {
        if (this.sym.enclClass().sourcefile == null) {
            return null;
        }
        return SourcePositionImpl.make(this.sym.enclClass().sourcefile.toString(), this.tree == null ? 0 : this.tree.pos);
    }
}

