/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.util;

import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javac.v8.util.StaticName;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class FileEntry {
    private static final int UNDET = -2;
    private long lastmod = -2L;

    public abstract InputStream open() throws IOException;

    public abstract Name getName();

    public abstract String getPath();

    public abstract long length();

    public String toString() {
        return this.getName().toString();
    }

    abstract long lastMod();

    public long lastModified() {
        if (this.lastmod == -2L) {
            this.lastmod = this.lastMod();
        }
        return this.lastmod;
    }

    public static class Zipped
    extends FileEntry {
        Name name;
        ZipFile zdir;
        ZipEntry entry;

        public Zipped(String string, ZipFile zipFile, ZipEntry zipEntry) {
            this.name = StaticName.fromString(string);
            this.zdir = zipFile;
            this.entry = zipEntry;
        }

        public InputStream open() throws IOException {
            return this.zdir.getInputStream(this.entry);
        }

        public Name getName() {
            return this.name;
        }

        public String getPath() {
            return this.zdir.getName() + "(" + this.entry.toString() + ")";
        }

        public long length() {
            return this.entry.getSize();
        }

        long lastMod() {
            return this.entry.getTime();
        }
    }

    public static class Regular
    extends FileEntry {
        Name name;
        File f;

        public Regular(String string, File file) {
            this.name = StaticName.fromString(string);
            this.f = file;
        }

        public InputStream open() throws IOException {
            return new FileInputStream(this.f);
        }

        public Name getName() {
            return this.name;
        }

        public String getPath() {
            return this.f.getPath();
        }

        public long length() {
            return this.f.length();
        }

        long lastMod() {
            return this.f.lastModified();
        }
    }
}

