/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.comp;

import com.sun.tools.javac.v8.code.ClassReader;
import com.sun.tools.javac.v8.code.Flags;
import com.sun.tools.javac.v8.code.Kinds;
import com.sun.tools.javac.v8.code.Scope;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.code.Type;
import com.sun.tools.javac.v8.code.TypeTags;
import com.sun.tools.javac.v8.comp.Symtab;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.tree.TreeInfo;
import com.sun.tools.javac.v8.util.Abort;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.Log;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javac.v8.util.Names;
import com.sun.tools.javac.v8.util.Set;
import com.sun.tools.javac.v8.util.StaticName;

public class Check
implements Kinds,
Flags,
TypeTags {
    Log log;
    Symtab syms;
    boolean gj;
    boolean warnunchecked;
    boolean deprecation;
    public Hashtable compiled = Hashtable.make();
    public Name deprecatedSource;
    public Name uncheckedSource;
    private Validator validator = new Validator();

    public Check(Log log, Symtab symtab, Hashtable hashtable) {
        this.log = log;
        this.syms = symtab;
        this.gj = hashtable.get("-gj") != null;
        this.warnunchecked = hashtable.get("-warnunchecked") != null;
        this.deprecation = hashtable.get("-deprecation") != null;
    }

    void warnDeprecated(int n, Symbol symbol) {
        if (this.compiled.get(symbol.enclClass().flatname) == null) {
            if (this.deprecatedSource == null) {
                this.deprecatedSource = this.log.currentSource();
            } else if (this.deprecatedSource != this.log.currentSource()) {
                this.deprecatedSource = Names.asterisk;
            }
            if (this.deprecation) {
                this.log.warning(n, "has.been.deprecated", symbol.toJava(), symbol.javaLocation());
            }
        }
    }

    void warnUnchecked(int n, String string) {
        this.warnUnchecked(n, string, null, null, null, null);
    }

    void warnUnchecked(int n, String string, String string2) {
        this.warnUnchecked(n, string, string2, null, null, null);
    }

    void warnUnchecked(int n, String string, String string2, String string3) {
        this.warnUnchecked(n, string, string2, string3, null, null);
    }

    void warnUnchecked(int n, String string, String string2, String string3, String string4) {
        this.warnUnchecked(n, string, string2, string3, string4, null);
    }

    void warnUnchecked(int n, String string, String string2, String string3, String string4, String string5) {
        if (this.uncheckedSource == null) {
            this.uncheckedSource = this.log.currentSource();
        } else if (this.uncheckedSource != this.log.currentSource()) {
            this.uncheckedSource = Names.asterisk;
        }
        if (this.warnunchecked) {
            this.log.warning(n, string, string2, string3, string4, string5);
        }
    }

    Type completionError(int n, Symbol.CompletionFailure completionFailure) {
        this.log.error(n, "cant.access", completionFailure.sym.toJava(), completionFailure.errmsg);
        if (completionFailure instanceof ClassReader.BadClassFile) {
            throw new Abort();
        }
        return Type.errType;
    }

    Type typeError(int n, String string, Type type, Type type2) {
        this.log.error(n, "prob.found.req", string, type.toJava(), type2.toJava());
        return Type.errType;
    }

    Type typeTagError(int n, String string, Type type) {
        this.log.error(n, "type.found.req", type.toJava(), string);
        return Type.errType;
    }

    void earlyRefError(int n, Symbol symbol) {
        this.log.error(n, "cant.ref.before.ctor.called", symbol.toJava());
    }

    void boundError(int n, Type type, Type type2, String string) {
        if (string.equals("")) {
            this.log.error(n, "not.within.bounds", type.toJava());
        } else {
            this.log.error(n, "not.within.bounds.explain", type.toJava(), string);
        }
    }

    Name localClassName(Symbol.ClassSymbol classSymbol, int n) {
        Symbol.ClassSymbol classSymbol2 = classSymbol.outermostClass();
        Name name = StaticName.fromString(classSymbol2.flatname + "$" + n + (classSymbol.name.len == 0 ? "" : "$" + classSymbol.name));
        if (this.compiled.get(name) != null) {
            return this.localClassName(classSymbol, n + 1);
        }
        return name;
    }

    Type checkType(int n, Type type, Type type2) {
        if (type2.tag == 18) {
            return type2;
        }
        if (type.isAssignable(type2)) {
            return type;
        }
        if (type.isRaw() && type.unerasure().isAssignable(type2)) {
            this.warnUnchecked(n, "unchecked.assign", type.toJava(), type2.toJava());
            return type;
        }
        String string = type.tag <= 7 && type2.tag <= 7 ? Log.getLocalizedString("possible.loss.of.precision") : Log.getLocalizedString("incompatible.types");
        return this.typeError(n, string, type, type2);
    }

    Type checkCastable(int n, Type type, Type type2) {
        if (type.isCastable(type2)) {
            this.checkCompatible(n, type, type2);
            return type2;
        }
        return this.typeError(n, Log.getLocalizedString("inconvertible.types"), type, type2);
    }

    Type checkNonVoid(int n, Type type) {
        if (type.tag == 9) {
            this.log.error(n, "void.not.allowed.here");
            return Type.errType;
        }
        return type;
    }

    Type checkClassType(int n, Type type) {
        if (type.tag != 10 && type.tag != 18) {
            return this.typeTagError(n, Log.getLocalizedString("type.req.class"), type);
        }
        return type;
    }

    Type checkClassOrArrayType(int n, Type type) {
        if (type.tag != 10 && type.tag != 11 && type.tag != 18) {
            return this.typeTagError(n, Log.getLocalizedString("type.req.class.array"), type);
        }
        return type;
    }

    Type checkRefType(int n, Type type) {
        if (type.tag != 10 && type.tag != 11 && type.tag != 14 && type.tag != 18) {
            return this.typeTagError(n, Log.getLocalizedString("type.req.ref"), type);
        }
        return type;
    }

    boolean checkDisjoint(int n, int n2, int n3, int n4) {
        if ((n2 & n3) != 0 && (n2 & n4) != 0) {
            this.log.error(n, "illegal.combination.of.modifiers", TreeInfo.flagNames(TreeInfo.firstFlag(n2 & n3)), TreeInfo.flagNames(TreeInfo.firstFlag(n2 & n4)));
            return false;
        }
        return true;
    }

    int checkFlags(int n, int n2, Symbol symbol) {
        int n3;
        int n4 = 0;
        switch (symbol.kind) {
            case 4: {
                if (symbol.owner.kind != 2) {
                    n3 = 16;
                    break;
                }
                if ((symbol.owner.flags_field & 0x200) != 0) {
                    n4 = 25;
                    n3 = 25;
                    break;
                }
                n3 = 223;
                break;
            }
            case 16: {
                if (symbol.name == Names.init) {
                    n3 = 7;
                } else if ((symbol.owner.flags_field & 0x200) != 0) {
                    n4 = 1025;
                    n3 = 1025;
                } else {
                    n3 = 3391;
                }
                n4 |= symbol.owner.flags_field & 0x800;
                break;
            }
            case 2: {
                if (symbol.isLocal()) {
                    n3 = 3088;
                    if (symbol.name.len == 0) {
                        n3 |= 8;
                    }
                } else if (symbol.owner.kind == 2) {
                    n3 = 3607;
                    if (symbol.owner.owner.kind == 1 || (symbol.owner.flags_field & 8) != 0) {
                        n3 |= 8;
                    }
                    if ((n2 & 0x200) != 0) {
                        n4 = 8;
                    }
                } else {
                    n3 = 3601;
                }
                if ((n2 & 0x200) != 0) {
                    n4 |= 0x400;
                }
                n4 |= symbol.owner.flags_field & 0x800;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        int n5 = n2 & 0xFFF & ~n3;
        if (n5 != 0) {
            this.log.error(n, "mod.not.allowed.here", TreeInfo.flagNames(n5));
        } else if (symbol.kind != 2 && !this.checkDisjoint(n, n2, 1024, 10) || !this.checkDisjoint(n, n2, 1536, 304) || !this.checkDisjoint(n, n2, 1, 6) || !this.checkDisjoint(n, n2, 2, 5) || !this.checkDisjoint(n, n2, 16, 64) || symbol.kind == 2 || this.checkDisjoint(n, n2, 1280, 2048)) {
            // empty if block
        }
        return n2 & (n3 | 0xFFFFF000) | n4;
    }

    void validate(Tree tree) {
        try {
            if (tree != null) {
                tree.visit(this.validator);
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.completionError(tree.pos, completionFailure);
        }
    }

    void validate(List list) {
        List list2 = list;
        while (list2.nonEmpty()) {
            this.validate((Tree)list2.head);
            list2 = list2.tail;
        }
    }

    static boolean subset(Type type, List list) {
        List list2 = list;
        while (list2.nonEmpty()) {
            if (type.isSubType((Type)list2.head)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    static boolean intersects(Type type, List list) {
        List list2 = list;
        while (list2.nonEmpty()) {
            if (type.isSubType((Type)list2.head) || ((Type)list2.head).isSubType(type)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    static List incl(Type type, List list) {
        return Check.subset(type, list) ? list : Check.excl(type, list).prepend(type);
    }

    static List excl(Type type, List list) {
        if (list.isEmpty()) {
            return list;
        }
        List list2 = Check.excl(type, list.tail);
        if (((Type)list.head).isSubType(type)) {
            return list2;
        }
        if (list2 == list.tail) {
            return list;
        }
        return list2.prepend(list.head);
    }

    static List union(List list, List list2) {
        List list3 = list;
        List list4 = list2;
        while (list4.nonEmpty()) {
            list3 = Check.incl((Type)list4.head, list3);
            list4 = list4.tail;
        }
        return list3;
    }

    static List diff(List list, List list2) {
        List list3 = list;
        List list4 = list2;
        while (list4.nonEmpty()) {
            list3 = Check.excl((Type)list4.head, list3);
            list4 = list4.tail;
        }
        return list3;
    }

    static List intersect(List list, List list2) {
        List list3 = Type.emptyList;
        List list4 = list;
        while (list4.nonEmpty()) {
            if (Check.subset((Type)list4.head, list2)) {
                list3 = Check.incl((Type)list4.head, list3);
            }
            list4 = list4.tail;
        }
        List list5 = list2;
        while (list5.nonEmpty()) {
            if (Check.subset((Type)list5.head, list)) {
                list3 = Check.incl((Type)list5.head, list3);
            }
            list5 = list5.tail;
        }
        return list3;
    }

    boolean isUnchecked(Symbol.ClassSymbol classSymbol) {
        return classSymbol == Type.errType.tsym || classSymbol.isSubClass(this.syms.errorType.tsym) || classSymbol.isSubClass(this.syms.runtimeExceptionType.tsym);
    }

    boolean isUnchecked(Type type) {
        if (type.tag == 14) {
            return this.isUnchecked(type.supertype());
        }
        if (type.tag == 10) {
            return this.isUnchecked((Symbol.ClassSymbol)type.tsym);
        }
        return false;
    }

    boolean isUnchecked(int n, Type type) {
        try {
            return this.isUnchecked(type);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.completionError(n, completionFailure);
            return true;
        }
    }

    boolean isHandled(Type type, List list) {
        return this.isUnchecked(type) || Check.subset(type, list);
    }

    List unHandled(List list, List list2) {
        List list3 = Type.emptyList;
        List list4 = list;
        while (list4.nonEmpty()) {
            if (!this.isHandled((Type)list4.head, list2)) {
                list3 = list3.prepend(list4.head);
            }
            list4 = list4.tail;
        }
        return list3;
    }

    void checkHandled(int n, Type type, List list) {
        if (!this.isHandled(type, list)) {
            this.log.error(n, "unreported.exception.need.to.catch.or.throw", type.toJava());
        }
    }

    void checkHandled(int n, List list, List list2) {
        List list3 = this.unHandled(list, list2);
        if (list3.nonEmpty()) {
            this.checkHandled(n, (Type)list3.head, list2);
        }
    }

    static int protection(int n) {
        switch (n & 7) {
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return 2;
    }

    private static String protectionString(int n) {
        int n2 = n & 7;
        return n2 == 0 ? "package" : TreeInfo.flagNames(n2);
    }

    static String cannotOverride(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        String string = (methodSymbol2.flags() & 0x200000 | methodSymbol2.owner.flags() & 0x200) == 0 ? Log.getLocalizedString("cant.override", methodSymbol.toJava(), methodSymbol.javaLocation(), methodSymbol2.toJava(), methodSymbol2.javaLocation()) : ((methodSymbol.flags() & 0x200000 | methodSymbol.owner.flags() & 0x200) == 0 ? Log.getLocalizedString("cant.implement", methodSymbol.toJava(), methodSymbol.javaLocation(), methodSymbol2.toJava(), methodSymbol2.javaLocation()) : Log.getLocalizedString("clashes.with", methodSymbol.toJava(), methodSymbol.javaLocation(), methodSymbol2.toJava(), methodSymbol2.javaLocation()));
        return string;
    }

    void checkOverride(int n, Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2, Symbol.ClassSymbol classSymbol) {
        if ((methodSymbol2.flags() & 0x10000) == 0) {
            if ((methodSymbol.flags() & 8) != 0 && (methodSymbol2.flags() & 8) == 0) {
                this.log.error(n, "override.static", Check.cannotOverride(methodSymbol, methodSymbol2), methodSymbol.toJava(), methodSymbol2.toJava());
            } else if ((methodSymbol2.flags() & 0x10) != 0 || (methodSymbol.flags() & 8) == 0 && (methodSymbol2.flags() & 8) != 0) {
                this.log.error(n, "override.meth", Check.cannotOverride(methodSymbol, methodSymbol2), TreeInfo.flagNames(methodSymbol2.flags() & 0x18));
            } else if ((classSymbol.flags() & 0x200) == 0 && Check.protection(methodSymbol.flags()) > Check.protection(methodSymbol2.flags())) {
                this.log.error(n, "override.weaker.access", Check.cannotOverride(methodSymbol, methodSymbol2), Check.protectionString(methodSymbol2.flags()));
            } else {
                List list;
                boolean bl;
                Type type = classSymbol.type.memberType(methodSymbol);
                Type type2 = classSymbol.type.memberType(methodSymbol2);
                List list2 = type.typarams();
                List list3 = type2.typarams();
                Type type3 = type2.restype().subst(list3, list2);
                boolean bl2 = bl = this.gj && type.restype().isSubType(type3) && type3.tag > 8 || type.restype().isSameType(type3);
                if (!bl) {
                    if (this.gj && (methodSymbol.flags() & 0x200000) != 0 && type3.isSubType(type.restype())) {
                        ((Type.MethodType)type).restype = type3;
                    } else {
                        this.typeError(n, Log.getLocalizedString("override.incompatible.ret", Check.cannotOverride(methodSymbol, methodSymbol2)), type.restype(), type2.restype().subst(list3, list2));
                    }
                } else if (((classSymbol.flags() & 0x200) == 0 || (methodSymbol2.owner.flags() & 0x200) != 0) && (list = this.unHandled(type.thrown(), type2.thrown())).nonEmpty()) {
                    this.log.error(n, "override.meth.doesnt.throw", Check.cannotOverride(methodSymbol, methodSymbol2), ((Type)list.head).toJava());
                }
                if ((methodSymbol2.flags() & 0x20000) != 0) {
                    this.warnDeprecated(n, methodSymbol2);
                }
            }
        }
    }

    void checkOverride(int n, Symbol.MethodSymbol methodSymbol) {
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)methodSymbol.owner;
        Type type = classSymbol.type.supertype();
        while (type.tag == 10) {
            Symbol.TypeSymbol typeSymbol = type.tsym;
            Scope.Entry entry = typeSymbol.members().lookup(methodSymbol.name);
            while (entry.scope != null) {
                if (methodSymbol.overrides(entry.sym, classSymbol)) {
                    this.checkOverride(n, methodSymbol, (Symbol.MethodSymbol)entry.sym, classSymbol);
                    return;
                }
                entry = entry.next();
            }
            type = type.supertype();
        }
    }

    public Symbol firstIncompatibility(Type type, Type type2) {
        return this.firstIncompatibility(type, type2, type2);
    }

    public Symbol firstIncompatibility(Type type, Type type2, Type type3) {
        Scope.Entry entry = type3.tsym.members().elems;
        while (entry != null) {
            if (entry.sym.kind == 16 && !this.isCompatible(type, type, type2, entry.sym)) {
                return entry.sym;
            }
            entry = entry.sibling;
        }
        List list = type3.interfaces();
        while (list.nonEmpty()) {
            Symbol symbol = this.firstIncompatibility(type, type2, (Type)list.head);
            if (symbol != null) {
                return symbol;
            }
            list = list.tail;
        }
        return null;
    }

    private boolean isCompatible(Type type, Type type2, Type type3, Symbol symbol) {
        Object object;
        Scope.Entry entry = type2.tsym.members().lookup(symbol.name);
        while (entry.scope != null) {
            Type type4;
            if (entry.sym.kind == 16 && ((Type)(object = type.memberType(entry.sym))).hasSameArgs(type4 = type3.memberType(symbol))) {
                Type type5;
                List list = ((Type)object).typarams();
                List list2 = type4.typarams();
                Type type6 = ((Type)object).restype();
                return type6.isSameType(type5 = type4.restype().subst(list2, list)) || type6.tag >= 10 && type5.tag >= 10 && (type6.isCastable(type5) || type5.isCastable(type6));
            }
            entry = entry.next();
        }
        object = type2.interfaces();
        while (((List)object).nonEmpty()) {
            if (!this.isCompatible(type, (Type)((List)object).head, type3, symbol)) {
                return false;
            }
            object = ((List)object).tail;
        }
        return true;
    }

    public boolean checkCompatible(int n, Type type, Type type2) {
        Symbol symbol;
        if (type.tag == 11 && type2.tag == 11) {
            this.checkCompatible(n, type.elemtype(), type2.elemtype());
        } else if (type.tag == 10 && (type.tsym.flags() & 0x200) != 0 && type2.tag == 10 && (type2.tsym.flags() & 0x200) != 0 && (symbol = this.firstIncompatibility(type, type2)) != null) {
            this.log.error(n, "intf.incompatible.diff.ret", type.toJava(), type2.toJava(), symbol.toJava());
            return false;
        }
        return true;
    }

    void checkAllDefined(int n, Symbol.ClassSymbol classSymbol) {
        try {
            Symbol.MethodSymbol methodSymbol = this.firstUndef(classSymbol, classSymbol);
            if (methodSymbol != null) {
                Symbol.MethodSymbol methodSymbol2 = new Symbol.MethodSymbol(methodSymbol.flags(), methodSymbol.name, classSymbol.type.memberType(methodSymbol), methodSymbol.owner);
                this.log.error(n, "should.be.abstract.doesnt.def", classSymbol.toJava(), methodSymbol2.toJava(), methodSymbol2.javaLocation());
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.completionError(n, completionFailure);
        }
    }

    private Symbol.MethodSymbol firstUndef(Symbol.ClassSymbol classSymbol, Symbol.ClassSymbol classSymbol2) {
        Object object = null;
        if (classSymbol2 == classSymbol || (classSymbol2.flags() & 0x600) != 0) {
            Object object2;
            Scope scope = classSymbol2.members();
            Scope.Entry entry = scope.elems;
            while (object == null && entry != null) {
                Symbol.MethodSymbol methodSymbol;
                if (entry.sym.kind == 16 && (entry.sym.flags() & 0x400) != 0 && ((methodSymbol = ((Symbol.MethodSymbol)(object2 = (Symbol.MethodSymbol)entry.sym)).implementation(classSymbol)) == null || methodSymbol == object2)) {
                    object = object2;
                }
                entry = entry.sibling;
            }
            if (object == null) {
                object2 = classSymbol2.type.supertype();
                if (((Type)object2).tag == 10) {
                    object = this.firstUndef(classSymbol, (Symbol.ClassSymbol)((Type)object2).tsym);
                }
            }
            object2 = classSymbol2.type.interfaces();
            while (object == null && ((List)object2).nonEmpty()) {
                object = this.firstUndef(classSymbol, (Symbol.ClassSymbol)((Type)((List)object2).head).tsym);
                object2 = ((List)object2).tail;
            }
        }
        return object;
    }

    void checkImplementations(int n, Symbol.ClassSymbol classSymbol) {
        List list = classSymbol.type.interfaces();
        while (list.nonEmpty()) {
            this.checkImplementations(n, classSymbol, (Symbol.ClassSymbol)((Type)list.head).tsym);
            list = list.tail;
        }
    }

    void checkImplementations(int n, Symbol.ClassSymbol classSymbol, Symbol.ClassSymbol classSymbol2) {
        Object object;
        Scope.Entry entry = classSymbol2.members().elems;
        while (entry != null) {
            Symbol.MethodSymbol methodSymbol;
            if (entry.sym.kind == 16 && (entry.sym.flags() & 8) == 0 && (methodSymbol = ((Symbol.MethodSymbol)(object = (Symbol.MethodSymbol)entry.sym)).implementation(classSymbol)) != null && (methodSymbol.owner.flags() & 0x200) == (classSymbol.flags() & 0x200)) {
                this.checkOverride(n, methodSymbol, (Symbol.MethodSymbol)object, classSymbol);
            }
            entry = entry.sibling;
        }
        object = classSymbol2.type.interfaces();
        while (((List)object).nonEmpty()) {
            this.checkImplementations(n, classSymbol, (Symbol.ClassSymbol)((Type)((List)object).head).tsym);
            object = ((List)object).tail;
        }
    }

    void checkCompatibleInterfaces(int n, Symbol.ClassSymbol classSymbol) {
        List list = classSymbol.type.interfaces();
        while (list.nonEmpty()) {
            List list2 = classSymbol.type.interfaces();
            while (list2 != list) {
                if (!this.checkCompatible(n, (Type)list.head, (Type)list2.head)) {
                    return;
                }
                list2 = list2.tail;
            }
            list = list.tail;
        }
    }

    void checkNotRepeated(int n, Type type, Set set) {
        if (set.contains(type)) {
            this.log.error(n, "repeated.interface");
        } else {
            set.put(type);
        }
    }

    class Validator
    extends Tree.Visitor {
        Validator() {
        }

        public void _case(Tree.TypeArray typeArray) {
            Check.this.validate(typeArray.elemtype);
        }

        public void _case(Tree.Select select) {
            if (select.type.tag == 10) {
                if (select.type.outer().tag == 10) {
                    Check.this.validate(select.selected);
                } else if (select.selected.type.isParameterized()) {
                    Check.this.log.error(select.pos, "cant.select.static.class.from.param.type");
                }
                if (select.type.isRaw() && select.type.allparams().nonEmpty()) {
                    Check.this.log.error(select.pos, "improperly.formed.type.param.missing");
                }
            }
        }

        public void _case(Tree tree) {
        }
    }
}

