/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.code;

import com.sun.tools.javac.v8.code.CRTable;
import com.sun.tools.javac.v8.code.ClassFile;
import com.sun.tools.javac.v8.code.Code;
import com.sun.tools.javac.v8.code.Flags;
import com.sun.tools.javac.v8.code.Kinds;
import com.sun.tools.javac.v8.code.Pool;
import com.sun.tools.javac.v8.code.Scope;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.code.Type;
import com.sun.tools.javac.v8.code.TypeTags;
import com.sun.tools.javac.v8.util.ByteBuffer;
import com.sun.tools.javac.v8.util.Convert;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.ListBuffer;
import com.sun.tools.javac.v8.util.Log;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javac.v8.util.Names;
import com.sun.tools.javac.v8.util.Set;
import com.sun.tools.javac.v8.util.StaticName;
import com.sun.tools.javac.v8.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class ClassWriter
extends ClassFile
implements Flags,
Kinds,
TypeTags {
    public File outDir = null;
    public boolean verbose;
    public boolean scramble;
    public boolean scrambleAll;
    public boolean retrofit;
    public boolean emitSourceFile;
    public boolean genCrt;
    public String target;
    public short majorVersion;
    public short minorVersion;
    static final int DATA_BUF_SIZE = 65520;
    static final int POOL_BUF_SIZE = 131056;
    ByteBuffer databuf = new ByteBuffer(65520);
    ByteBuffer poolbuf = new ByteBuffer(131056);
    ByteBuffer sigbuf = new ByteBuffer();
    Pool pool;
    Set innerClasses;
    ListBuffer innerClassesQueue;
    private static final String dumpModFlags = System.getProperty("javac.dump.modifiers");
    private static final boolean dumpClassModifiers = dumpModFlags != null && dumpModFlags.indexOf(99) != -1;
    private static final boolean dumpFieldModifiers = dumpModFlags != null && dumpModFlags.indexOf(102) != -1;
    private static final boolean dumpInnerClassModifiers = dumpModFlags != null && dumpModFlags.indexOf(105) != -1;
    private static final boolean dumpMethodModifiers = dumpModFlags != null && dumpModFlags.indexOf(109) != -1;
    private static final String[] flagName = new String[]{"PUBLIC", "PRIVATE", "PROTECTED", "STATIC", "FINAL", "SUPER", "VOLATILE", "TRANSIENT", "NATIVE", "INTERFACE", "ABSTRACT", "STRICTFP"};

    public ClassWriter(Hashtable hashtable) {
        this.verbose = hashtable.get("-verbose") != null;
        this.scramble = hashtable.get("-scramble") != null;
        this.scrambleAll = hashtable.get("-scrambleAll") != null;
        this.retrofit = hashtable.get("-retrofit") != null;
        this.target = (String)hashtable.get("-target");
        this.genCrt = hashtable.get("-Xjcov") != null;
        this.majorVersion = ClassFile.classMajorVersion(this.target);
        this.minorVersion = ClassFile.classMinorVersion(this.target);
        String string = (String)hashtable.get("-g:");
        this.emitSourceFile = string != null ? Util.contains(string, "source", ',') : true;
        String string2 = (String)hashtable.get("-d");
        if (string2 != null) {
            this.outDir = new File(string2);
        }
    }

    public static String flagNames(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = n & 0xFFF;
        while (n3 != 0) {
            if ((n3 & 1) != 0) {
                stringBuffer.append(" " + flagName[n2]);
            }
            n3 >>= 1;
            ++n2;
        }
        return stringBuffer.toString();
    }

    void putChar(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.elems[n] = (byte)(n2 >> 8 & 0xFF);
        byteBuffer.elems[n + 1] = (byte)(n2 & 0xFF);
    }

    void putInt(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.elems[n] = (byte)(n2 >> 24 & 0xFF);
        byteBuffer.elems[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byteBuffer.elems[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byteBuffer.elems[n + 3] = (byte)(n2 & 0xFF);
    }

    void assembleSig(Type type) {
        switch (type.tag) {
            case 1: {
                this.sigbuf.appendByte(66);
                break;
            }
            case 3: {
                this.sigbuf.appendByte(83);
                break;
            }
            case 2: {
                this.sigbuf.appendByte(67);
                break;
            }
            case 4: {
                this.sigbuf.appendByte(73);
                break;
            }
            case 5: {
                this.sigbuf.appendByte(74);
                break;
            }
            case 6: {
                this.sigbuf.appendByte(70);
                break;
            }
            case 7: {
                this.sigbuf.appendByte(68);
                break;
            }
            case 8: {
                this.sigbuf.appendByte(90);
                break;
            }
            case 9: {
                this.sigbuf.appendByte(86);
                break;
            }
            case 10: {
                Type.ClassType classType = (Type.ClassType)type;
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)classType.tsym;
                this.enterInner(classSymbol);
                if (classType.outer().allparams().nonEmpty()) {
                    this.assembleSig(classType.outer());
                    this.sigbuf.appendByte(46);
                }
                this.sigbuf.appendByte(76);
                this.sigbuf.appendBytes(ClassFile.externalize(classSymbol.flatname));
                this.sigbuf.appendByte(59);
                break;
            }
            case 11: {
                Type.ArrayType arrayType = (Type.ArrayType)type;
                this.sigbuf.appendByte(91);
                this.assembleSig(arrayType.elemtype);
                break;
            }
            case 12: {
                Type.MethodType methodType = (Type.MethodType)type;
                this.sigbuf.appendByte(40);
                this.assembleSig(methodType.argtypes);
                this.sigbuf.appendByte(41);
                this.assembleSig(methodType.restype);
                boolean bl = false;
                List list = methodType.thrown;
                while (list.nonEmpty() && !bl) {
                    bl = ((Type)list.head).tag == 14;
                    list = list.tail;
                }
                if (!bl) break;
                List list2 = methodType.thrown;
                while (list2.nonEmpty()) {
                    this.sigbuf.appendByte(94);
                    this.assembleSig((Type)list2.head);
                    list2 = list2.tail;
                }
                break;
            }
            default: {
                throw new InternalError("typeSig" + type.tag);
            }
        }
    }

    void assembleSig(List list) {
        List list2 = list;
        while (list2.nonEmpty()) {
            this.assembleSig((Type)list2.head);
            list2 = list2.tail;
        }
    }

    Name typeSig(Type type) {
        Util.assertion(this.sigbuf.length == 0);
        this.assembleSig(type);
        Name name = this.sigbuf.toName();
        this.sigbuf.reset();
        return name;
    }

    public Name xClassName(Type type) {
        if (type.tag == 10) {
            return StaticName.fromUtf(ClassFile.externalize(type.tsym.flatName()));
        }
        if (type.tag == 11) {
            return this.typeSig(type.erasure());
        }
        throw new InternalError("xClassName");
    }

    void writePool(Pool pool) {
        int n = this.poolbuf.length;
        this.poolbuf.appendChar(0);
        int n2 = 1;
        while (n2 < pool.pp) {
            Object object;
            Object object2 = pool.pool[n2];
            Util.assertion(object2 != null);
            if (object2 instanceof Name) {
                this.poolbuf.appendByte(1);
                object = ((Name)object2).toUtf();
                this.poolbuf.appendChar(((Object)object).length);
                this.poolbuf.appendBytes((byte[])object, 0, ((Object)object).length);
            } else if (object2 instanceof Symbol.ClassSymbol) {
                object = (Symbol.ClassSymbol)object2;
                if (((Symbol.ClassSymbol)object).owner.kind == 2) {
                    pool.put(((Symbol.ClassSymbol)object).owner);
                }
                this.poolbuf.appendByte(7);
                this.poolbuf.appendChar(pool.put(StaticName.fromUtf(ClassFile.externalize(((Symbol.ClassSymbol)object).flatname))));
                this.enterInner((Symbol.ClassSymbol)object);
            } else if (object2 instanceof Symbol.MethodSymbol) {
                object = (Symbol.MethodSymbol)object2;
                this.poolbuf.appendByte((((Symbol.MethodSymbol)object).owner.flags() & 0x200) != 0 ? 11 : 10);
                this.poolbuf.appendChar(pool.put(((Symbol.MethodSymbol)object).owner));
                this.poolbuf.appendChar(pool.put(this.nameType((Symbol)object)));
            } else if (object2 instanceof Symbol.VarSymbol) {
                object = (Symbol.VarSymbol)object2;
                this.poolbuf.appendByte(9);
                this.poolbuf.appendChar(pool.put(((Symbol.VarSymbol)object).owner));
                this.poolbuf.appendChar(pool.put(this.nameType((Symbol)object)));
            } else if (object2 instanceof ClassFile.NameAndType) {
                object = (ClassFile.NameAndType)object2;
                this.poolbuf.appendByte(12);
                this.poolbuf.appendChar(pool.put(((ClassFile.NameAndType)object).name));
                this.poolbuf.appendChar(pool.put(this.typeSig(((ClassFile.NameAndType)object).type)));
            } else if (object2 instanceof Integer) {
                this.poolbuf.appendByte(3);
                this.poolbuf.appendInt((Integer)object2);
            } else if (object2 instanceof Long) {
                this.poolbuf.appendByte(5);
                this.poolbuf.appendLong((Long)object2);
                ++n2;
            } else if (object2 instanceof Float) {
                this.poolbuf.appendByte(4);
                this.poolbuf.appendFloat(((Float)object2).floatValue());
            } else if (object2 instanceof Double) {
                this.poolbuf.appendByte(6);
                this.poolbuf.appendDouble((Double)object2);
                ++n2;
            } else if (object2 instanceof String) {
                this.poolbuf.appendByte(8);
                this.poolbuf.appendChar(pool.put(StaticName.fromString((String)object2)));
            } else if (object2 instanceof Type) {
                this.poolbuf.appendByte(7);
                this.poolbuf.appendChar(pool.put(this.xClassName((Type)object2)));
            } else {
                throw new InternalError("writePool " + object2);
            }
            ++n2;
        }
        this.putChar(this.poolbuf, n, pool.pp);
    }

    Name fieldName(Symbol symbol) {
        if (this.scramble && (symbol.flags() & 2) != 0 || this.scrambleAll && (symbol.flags() & 5) == 0) {
            return StaticName.fromString("_$" + symbol.name.index);
        }
        return symbol.name;
    }

    ClassFile.NameAndType nameType(Symbol symbol) {
        return new ClassFile.NameAndType(this.fieldName(symbol), this.retrofit ? symbol.erasure() : symbol.externalType());
    }

    int writeAttr(Name name) {
        this.databuf.appendChar(this.pool.put(name));
        this.databuf.appendInt(0);
        return this.databuf.length;
    }

    void endAttr(int n) {
        this.putInt(this.databuf, n - 4, this.databuf.length - n);
    }

    int beginAttrs() {
        this.databuf.appendChar(0);
        return this.databuf.length;
    }

    void endAttrs(int n, int n2) {
        this.putChar(this.databuf, n - 2, n2);
    }

    int writeFlagAttrs(int n) {
        int n2;
        int n3 = 0;
        if ((n & 0x20000) != 0) {
            n2 = this.writeAttr(Names.Deprecated);
            this.endAttr(n2);
            ++n3;
        }
        if ((n & 0x10000) != 0) {
            n2 = this.writeAttr(Names.Synthetic);
            this.endAttr(n2);
            ++n3;
        }
        return n3;
    }

    int writeMemberAttrs(Symbol symbol) {
        int n = this.writeFlagAttrs(symbol.flags());
        return n;
    }

    boolean isEmittable(Symbol symbol) {
        return (symbol.flags() & 0x200000) == 0 || this.majorVersion < ClassFile.MAJOR_VERSION_1_2;
    }

    void enterInner(Symbol.ClassSymbol classSymbol) {
        Util.assertion((classSymbol.flags() & 0x1000000) == 0);
        if (!(this.pool == null || classSymbol.owner.kind == 1 || this.innerClasses != null && this.innerClasses.contains(classSymbol))) {
            if (classSymbol.owner.kind == 2) {
                this.enterInner((Symbol.ClassSymbol)classSymbol.owner);
            }
            this.pool.put(classSymbol);
            this.pool.put(classSymbol.name);
            if (this.innerClasses == null) {
                this.innerClasses = Set.make();
                this.innerClassesQueue = new ListBuffer();
                this.pool.put(Names.InnerClasses);
            }
            this.innerClasses.put(classSymbol);
            this.innerClassesQueue.append(classSymbol);
        }
    }

    void writeInnerClasses() {
        int n = this.writeAttr(Names.InnerClasses);
        this.databuf.appendChar(this.innerClassesQueue.length());
        List list = this.innerClassesQueue.toList();
        while (list.nonEmpty()) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)list.head;
            if (dumpInnerClassModifiers) {
                System.out.println("INNERCLASS  " + classSymbol.name);
                System.out.println("---" + ClassWriter.flagNames(classSymbol.flags_field));
            }
            this.databuf.appendChar(this.pool.get(classSymbol));
            this.databuf.appendChar(classSymbol.owner.kind == 2 ? this.pool.get(classSymbol.owner) : 0);
            this.databuf.appendChar(classSymbol.name.len != 0 ? this.pool.get(classSymbol.name) : 0);
            this.databuf.appendChar(classSymbol.flags_field);
            list = list.tail;
        }
        this.endAttr(n);
    }

    void writeField(Symbol.VarSymbol varSymbol) {
        this.databuf.appendChar(varSymbol.flags());
        if (dumpFieldModifiers) {
            System.out.println("FIELD  " + this.fieldName(varSymbol));
            System.out.println("---" + ClassWriter.flagNames(varSymbol.flags()));
        }
        this.databuf.appendChar(this.pool.put(this.fieldName(varSymbol)));
        this.databuf.appendChar(this.pool.put(this.typeSig(varSymbol.erasure())));
        int n = this.beginAttrs();
        int n2 = 0;
        if (varSymbol.constValue != null) {
            int n3 = this.writeAttr(Names.ConstantValue);
            this.databuf.appendChar(this.pool.put(varSymbol.constValue));
            this.endAttr(n3);
            ++n2;
        }
        this.endAttrs(n, n2 += this.writeMemberAttrs(varSymbol));
    }

    void writeMethod(Symbol.MethodSymbol methodSymbol) {
        if (this.isEmittable(methodSymbol)) {
            List list;
            this.databuf.appendChar(methodSymbol.flags());
            if (dumpMethodModifiers) {
                System.out.println("METHOD  " + this.fieldName(methodSymbol));
                System.out.println("---" + ClassWriter.flagNames(methodSymbol.flags()));
            }
            this.databuf.appendChar(this.pool.put(this.fieldName(methodSymbol)));
            this.databuf.appendChar(this.pool.put(this.typeSig(methodSymbol.externalType())));
            int n = this.beginAttrs();
            int n2 = 0;
            if (methodSymbol.code != null) {
                int n3 = this.writeAttr(Names.Code);
                this.writeCode(methodSymbol.code);
                methodSymbol.code = null;
                this.endAttr(n3);
                ++n2;
            }
            if ((list = methodSymbol.erasure().thrown()).nonEmpty()) {
                int n4 = this.writeAttr(Names.Exceptions);
                this.databuf.appendChar(list.length());
                List list2 = list;
                while (list2.nonEmpty()) {
                    this.databuf.appendChar(this.pool.put(((Type)list2.head).tsym));
                    list2 = list2.tail;
                }
                this.endAttr(n4);
                ++n2;
            }
            this.endAttrs(n, n2 += this.writeMemberAttrs(methodSymbol));
        }
    }

    void writeCode(Code code) {
        int n;
        int n2;
        int n3;
        int n4;
        this.databuf.appendChar(code.max_stack);
        this.databuf.appendChar(code.max_locals);
        this.databuf.appendInt(code.cp);
        this.databuf.appendBytes(code.code, 0, code.cp);
        this.databuf.appendChar(code.catchInfo.length());
        List list = code.catchInfo.toList();
        while (list.nonEmpty()) {
            n4 = 0;
            while (n4 < ((char[])list.head).length) {
                this.databuf.appendChar(((char[])list.head)[n4]);
                ++n4;
            }
            list = list.tail;
        }
        n4 = this.beginAttrs();
        int n5 = 0;
        if (code.lineInfo.nonEmpty()) {
            n3 = this.writeAttr(Names.LineNumberTable);
            this.databuf.appendChar(code.lineInfo.length());
            List list2 = code.lineInfo.reverse();
            while (list2.nonEmpty()) {
                n2 = 0;
                while (n2 < ((char[])list2.head).length) {
                    this.databuf.appendChar(((char[])list2.head)[n2]);
                    ++n2;
                }
                list2 = list2.tail;
            }
            this.endAttr(n3);
            ++n5;
        }
        if (this.genCrt && code.crt != null) {
            CRTable cRTable = code.crt;
            int n6 = this.writeAttr(Names.CharacterRangeTable);
            n2 = this.beginAttrs();
            n = cRTable.writeCRT(this.databuf);
            this.endAttrs(n2, n);
            this.endAttr(n6);
            ++n5;
        }
        if (code.nvars > 0) {
            n3 = this.writeAttr(Names.LocalVariableTable);
            int n7 = code.nvars;
            n2 = 0;
            n = 0;
            while (n7 > 0) {
                if (code.lvar[n2] != null) {
                    if (code.lvar_start_pc[n2] != '\uffff') {
                        ++n;
                    } else {
                        code.lvar[n2] = null;
                    }
                    --n7;
                }
                ++n2;
            }
            this.databuf.appendChar(n);
            n2 = 0;
            while (n > 0) {
                if (code.lvar[n2] != null) {
                    this.databuf.appendChar(code.lvar_start_pc[n2]);
                    this.databuf.appendChar(code.lvar_length[n2]);
                    this.databuf.appendChar(this.pool.put(code.lvar[n2].name));
                    this.databuf.appendChar(this.pool.put(this.typeSig(code.lvar[n2].erasure())));
                    this.databuf.appendChar(code.lvar_reg[n2]);
                    --n;
                }
                ++n2;
            }
            this.endAttr(n3);
            ++n5;
        }
        this.endAttrs(n4, n5);
    }

    void writeFields(Scope.Entry entry) {
        if (entry != null) {
            this.writeFields(entry.sibling);
            if (entry.sym.kind == 4) {
                this.writeField((Symbol.VarSymbol)entry.sym);
            }
        }
    }

    void writeMethods(Scope.Entry entry) {
        if (entry != null) {
            this.writeMethods(entry.sibling);
            if (entry.sym.kind == 16) {
                this.writeMethod((Symbol.MethodSymbol)entry.sym);
            }
        }
    }

    public void writeClassFile(OutputStream outputStream, Symbol.ClassSymbol classSymbol) throws IOException {
        int n;
        Util.assertion((classSymbol.flags() & 0x1000000) == 0);
        this.databuf.reset();
        this.poolbuf.reset();
        this.sigbuf.reset();
        this.pool = classSymbol.pool;
        this.innerClasses = null;
        this.innerClassesQueue = null;
        Type type = classSymbol.type.supertype();
        List list = classSymbol.type.interfaces();
        int n2 = classSymbol.flags();
        if ((n2 & 4) != 0) {
            n2 |= 1;
        }
        if (((n2 = n2 & 0xE11 & 0xFFFFF7FF) & 0x200) == 0) {
            n2 |= 0x20;
        }
        if (dumpClassModifiers) {
            System.out.println();
            System.out.println("CLASSFILE  " + classSymbol.fullName());
            System.out.println("---" + ClassWriter.flagNames(n2));
        }
        this.databuf.appendChar(n2);
        this.databuf.appendChar(this.pool.put(classSymbol));
        this.databuf.appendChar(type.tag == 10 ? this.pool.put(type.tsym) : 0);
        this.databuf.appendChar(list.length());
        List list2 = list;
        while (list2.nonEmpty()) {
            this.databuf.appendChar(this.pool.put(((Type)list2.head).tsym));
            list2 = list2.tail;
        }
        int n3 = 0;
        int n4 = 0;
        Scope.Entry entry = classSymbol.members().elems;
        while (entry != null) {
            switch (entry.sym.kind) {
                case 4: {
                    ++n3;
                    break;
                }
                case 16: {
                    if (!this.isEmittable(entry.sym)) break;
                    ++n4;
                    break;
                }
                case 2: {
                    this.enterInner((Symbol.ClassSymbol)entry.sym);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            entry = entry.sibling;
        }
        this.databuf.appendChar(n3);
        this.writeFields(classSymbol.members().elems);
        this.databuf.appendChar(n4);
        this.writeMethods(classSymbol.members().elems);
        int n5 = this.beginAttrs();
        int n6 = 0;
        if (classSymbol.sourcefile != null && this.emitSourceFile) {
            n = this.writeAttr(Names.SourceFile);
            String string = classSymbol.sourcefile.toString();
            int n7 = string.lastIndexOf(File.separatorChar);
            int n8 = string.lastIndexOf(47);
            if (n8 > n7) {
                n7 = n8;
            }
            if (n7 >= 0) {
                string = string.substring(n7 + 1);
            }
            this.databuf.appendChar(classSymbol.pool.put(StaticName.fromString(string)));
            this.endAttr(n);
            ++n6;
        }
        if (this.genCrt) {
            n = this.writeAttr(Names.SourceID);
            this.databuf.appendChar(classSymbol.pool.put(StaticName.fromString(Long.toString(this.getLastModified(classSymbol.sourcefile)))));
            this.endAttr(n);
            ++n6;
            n = this.writeAttr(Names.CompilationID);
            this.databuf.appendChar(classSymbol.pool.put(StaticName.fromString(Long.toString(System.currentTimeMillis()))));
            this.endAttr(n);
            ++n6;
        }
        n6 += this.writeFlagAttrs(classSymbol.flags());
        this.poolbuf.appendInt(-889275714);
        this.poolbuf.appendChar(this.minorVersion);
        this.poolbuf.appendChar(this.majorVersion);
        this.writePool(classSymbol.pool);
        if (classSymbol.pool.pp > 65535) {
            throw new IOException(Log.getLocalizedString("too.many.constants"));
        }
        if (this.innerClasses != null) {
            this.writeInnerClasses();
            ++n6;
        }
        this.endAttrs(n5, n6);
        this.poolbuf.appendBytes(this.databuf.elems, 0, this.databuf.length);
        outputStream.write(this.poolbuf.elems, 0, this.poolbuf.length);
        classSymbol.pool = null;
        this.pool = null;
    }

    long getLastModified(Name name) {
        long l = 0L;
        File file = new File(name.toString());
        try {
            l = file.lastModified();
        }
        catch (SecurityException securityException) {
            throw new InternalError("CRT: couldn't get source file modification date: " + securityException.getMessage());
        }
        return l;
    }

    public File outputFile(Symbol.ClassSymbol classSymbol, String string) throws IOException {
        if (this.outDir == null) {
            String string2 = Convert.shortName(classSymbol.flatname) + string;
            if (classSymbol.sourcefile == null) {
                return new File(string2);
            }
            String string3 = new File(classSymbol.sourcefile.toString()).getParent();
            if (string3 == null) {
                return new File(string2);
            }
            return new File(string3, string2);
        }
        return this.outputFile(this.outDir, classSymbol.flatname.toString(), string);
    }

    File outputFile(File file, String string, String string2) throws IOException {
        int n = 0;
        int n2 = string.indexOf(46);
        while (n2 >= n) {
            if (!(file = new File(file, string.substring(n, n2))).exists()) {
                file.mkdir();
            }
            n = n2 + 1;
            n2 = string.indexOf(46, n);
        }
        return new File(file, string.substring(n) + string2);
    }
}

