/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8;

import com.sun.tools.javac.v8.JavaCompiler;
import com.sun.tools.javac.v8.code.ClassReader;
import com.sun.tools.javac.v8.code.CompleteClassReader;
import com.sun.tools.javac.v8.code.Flags;
import com.sun.tools.javac.v8.code.Kinds;
import com.sun.tools.javac.v8.code.Scope;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.code.Type;
import com.sun.tools.javac.v8.code.TypeTags;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.Log;
import java.io.IOException;

public class Retro
implements TypeTags,
Kinds,
Flags {
    ClassReader reader;
    JavaCompiler comp;
    boolean verbose;

    Retro(JavaCompiler javaCompiler, Hashtable hashtable) {
        this.comp = javaCompiler;
        this.reader = new CompleteClassReader(hashtable);
        this.reader.classPath = (String)hashtable.get("-retrofit") + ClassReader.pathSep + this.reader.classPath;
        this.reader.readAllOfClassFile = true;
        this.verbose = hashtable.get("-verbose") != null;
    }

    static boolean isGeneric(Type type) {
        switch (type.tag) {
            case 10: {
                return type.typarams().nonEmpty();
            }
            case 11: {
                return Retro.isGeneric(type.elemtype());
            }
            case 12: {
                return Retro.isGeneric(type.argtypes()) || Retro.isGeneric(type.restype());
            }
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    static boolean isGeneric(List list) {
        List list2 = list;
        while (list2.nonEmpty()) {
            if (Retro.isGeneric((Type)list2.head)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    static boolean isSameType(Type type, Type type2) {
        return type.tag == 10 && type2.tag == 10 && type.tsym.fullName() == type2.tsym.fullName() || type.tag == 11 && type2.tag == 11 && Retro.isSameType(type.elemtype(), type2.elemtype()) || type.tag == 12 && type2.tag == 12 && Retro.isSameType(type.restype(), type2.restype()) && Retro.isSameTypes(type.argtypes(), type2.argtypes()) || type.isSameType(type2);
    }

    static boolean isSameTypes(List list, List list2) {
        while (list.nonEmpty() && list2.nonEmpty() && Retro.isSameType((Type)list.head, (Type)list2.head)) {
            list = list.tail;
            list2 = list2.tail;
        }
        return list.isEmpty() && list2.isEmpty();
    }

    public void fitClass(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.owner.kind == 1) {
            this.fit(classSymbol);
        }
    }

    public void fit(Symbol.ClassSymbol classSymbol) {
        try {
            if (this.verbose) {
                this.printVerbose("retro", classSymbol.toJava());
            }
            Symbol.ClassSymbol classSymbol2 = this.reader.loadClass(classSymbol.flatname);
            if (!Retro.isSameType(classSymbol.type.supertype(), classSymbol2.type.supertype())) {
                this.comp.log.error(0, "signature.doesnt.match.supertype", classSymbol2.toJava());
                return;
            }
            if (!Retro.isSameTypes(classSymbol.type.interfaces(), classSymbol2.type.interfaces())) {
                this.comp.log.error(0, "signature.doesnt.match.intf", classSymbol2.toJava());
                return;
            }
            if (Retro.isGeneric(classSymbol.type) || Retro.isGeneric(classSymbol.type.supertype()) || Retro.isGeneric(classSymbol.type.interfaces())) {
                if (this.verbose) {
                    this.printVerbose("retro.with.list", classSymbol2.toJava(), Type.toJavaList(classSymbol.type.typarams()), classSymbol.type.supertype().toJava(), Type.toJavaList(classSymbol.type.interfaces()));
                }
                classSymbol2.type = classSymbol.type;
            }
            Scope.Entry entry = classSymbol.members().elems;
            while (entry != null) {
                Symbol symbol = entry.sym;
                if ((symbol.flags() & 0x10002) == 0) {
                    switch (symbol.kind) {
                        case 2: {
                            if (symbol.name.len == 0) break;
                            this.fit((Symbol.ClassSymbol)symbol);
                            break;
                        }
                        case 4: 
                        case 16: {
                            Scope scope = classSymbol2.members();
                            Scope.Entry entry2 = scope.lookup(symbol.name);
                            while (!(entry2.scope != scope || entry2.sym.kind == symbol.kind && Retro.isSameType(entry2.sym.erasure(), symbol.erasure()))) {
                                entry2 = entry2.next();
                            }
                            if (entry2.scope == scope) {
                                if (!Retro.isGeneric(symbol.type)) break;
                                if (this.verbose) {
                                    this.printVerbose("retro.with", entry2.sym.toJava(), symbol.type.toJava());
                                }
                                entry2.sym.type = symbol.type;
                                break;
                            }
                            this.comp.log.error(0, "no.match.entry", symbol.toJava(), classSymbol2.toJava(), symbol.erasure().toJava());
                        }
                    }
                }
                entry = entry.sibling;
            }
            if (this.comp.log.nerrors == 0) {
                this.comp.writeClass(classSymbol2);
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.comp.log.error(0, "cant.access", completionFailure.sym.toJava(), completionFailure.errmsg);
        }
        catch (IOException iOException) {
            this.comp.log.error(0, "class.cant.write", classSymbol.toJava(), iOException.getMessage());
        }
    }

    void printVerbose(String string, String string2) {
        this.printVerbose(string, string2, null, null, null);
    }

    void printVerbose(String string, String string2, String string3) {
        this.printVerbose(string, string2, string3, null, null);
    }

    void printVerbose(String string, String string2, String string3, String string4) {
        this.printVerbose(string, string2, string3, string4, null);
    }

    private void printVerbose(String string, String string2, String string3, String string4, String string5) {
        System.err.println(Log.getLocalizedString("verbose." + string, string2, string3, string4, string5));
    }
}

