/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import com.sun.tools.doclets.standard.HtmlStandardWriter;
import java.io.IOException;

public class FrameOutputWriter
extends HtmlStandardWriter {
    int noOfPackages;

    public FrameOutputWriter(ConfigurationStandard configurationStandard, String string) throws IOException {
        super(configurationStandard, string);
        this.noOfPackages = configurationStandard.packages.length;
    }

    public static void generate(ConfigurationStandard configurationStandard) {
        String string = "";
        try {
            string = "index.html";
            FrameOutputWriter frameOutputWriter = new FrameOutputWriter(configurationStandard, string);
            frameOutputWriter.generateFrameFile();
            frameOutputWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generateFrameFile() {
        if (this.configuration.windowtitle.length() > 0) {
            this.printPartialHeader(this.configuration.windowtitle);
        } else {
            this.printPartialHeader(this.getText("doclet.Generated_Docs_Untitled"));
        }
        this.printFrameDetails();
        this.printFrameWarning();
        this.printFrameFooter();
    }

    protected void printFrameWarning() {
        this.noFrames();
        this.h2();
        this.printText("doclet.Frame_Alert");
        this.h2End();
        this.p();
        this.printText("doclet.Frame_Warning_Message");
        this.br();
        this.printText("doclet.Link_To");
        this.printHyperLink(this.configuration.topFile, this.getText("doclet.Non_Frame_Version"));
        this.noFramesEnd();
    }

    protected void printFrameDetails() {
        this.frameSet("cols=\"20%,80%\"");
        if (this.noOfPackages <= 1) {
            this.frame("src=\"allclasses-frame.html\" name=\"packageFrame\"");
            this.frame("src=\"" + this.configuration.topFile + "\" name=\"classFrame\"");
        } else if (this.noOfPackages > 1) {
            this.frameSet("rows=\"30%,70%\"");
            this.frame("src=\"overview-frame.html\" name=\"packageListFrame\"");
            this.frame("src=\"allclasses-frame.html\" name=\"packageFrame\"");
            this.frameSetEnd();
            this.frame("src=\"" + this.configuration.topFile + "\" name=\"classFrame\"");
        }
        this.frameSetEnd();
    }
}

