/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.MessageRetriever;
import com.sun.tools.doclets.Taglet;
import com.sun.tools.doclets.TagletManager;
import com.sun.tools.doclets.Util;
import com.sun.tools.doclets.VisibleMemberMap;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import com.sun.tools.doclets.standard.HtmlStandardWriter;
import com.sun.tools.doclets.standard.SubWriterHolderWriter;
import com.sun.tools.doclets.standard.tags.SeeTaglet;
import com.sun.tools.doclets.standard.tags.SimpleTaglet;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSubWriter {
    protected boolean printedSummaryHeader = false;
    protected final SubWriterHolderWriter writer;
    protected final ClassDoc classdoc;
    public final boolean nodepr;
    public VisibleMemberMap visibleMemberMap = null;
    public List visibleClasses = null;

    public AbstractSubWriter(SubWriterHolderWriter subWriterHolderWriter, ClassDoc classDoc) {
        this.writer = subWriterHolderWriter;
        this.nodepr = this.configuration().nodeprecated;
        this.classdoc = classDoc;
        if (classDoc != null) {
            this.buildVisibleMemberMap();
        }
    }

    public AbstractSubWriter(SubWriterHolderWriter subWriterHolderWriter) {
        this(subWriterHolderWriter, null);
    }

    public abstract int getMemberKind();

    public abstract void printSummaryLabel(ClassDoc var1);

    public abstract void printInheritedSummaryLabel(ClassDoc var1);

    public abstract void printSummaryAnchor(ClassDoc var1);

    public abstract void printInheritedSummaryAnchor(ClassDoc var1);

    protected abstract void printSummaryType(ProgramElementDoc var1);

    protected abstract void printSummaryLink(ClassDoc var1, ProgramElementDoc var2);

    protected abstract void printInheritedSummaryLink(ClassDoc var1, ProgramElementDoc var2);

    protected abstract void printHeader(ClassDoc var1);

    protected abstract void printBodyHtmlEnd(ClassDoc var1);

    protected abstract void printMember(ProgramElementDoc var1);

    protected abstract void printDeprecatedLink(ProgramElementDoc var1);

    protected abstract void printNavSummaryLink(ClassDoc var1, boolean var2);

    protected abstract void printNavDetailLink(boolean var1);

    protected void print(String string) {
        this.writer.print(string);
        this.writer.displayLength += string.length();
    }

    protected void print(char c) {
        this.writer.print(c);
        ++this.writer.displayLength;
    }

    protected void bold(String string) {
        this.writer.bold(string);
        this.writer.displayLength += string.length();
    }

    protected void printTypeLinkNoDimension(Type type) {
        ClassDoc classDoc = type.asClassDoc();
        if (classDoc == null) {
            this.print(type.typeName());
        } else {
            this.writer.printClassLink(classDoc);
        }
    }

    protected void printTypeLink(Type type) {
        this.printTypeLinkNoDimension(type);
        this.print(type.dimension());
    }

    protected String modifierString(MemberDoc memberDoc) {
        int n = memberDoc.modifierSpecifier();
        int n2 = 288;
        return Modifier.toString(n & ~n2);
    }

    protected String typeString(MemberDoc memberDoc) {
        String string = "";
        if (memberDoc instanceof MethodDoc) {
            string = ((MethodDoc)memberDoc).returnType().toString();
        } else if (memberDoc instanceof FieldDoc) {
            string = ((FieldDoc)memberDoc).type().toString();
        }
        return string;
    }

    protected void printModifiers(MemberDoc memberDoc) {
        String string = this.modifierString(memberDoc);
        if (string.length() > 0) {
            this.print(string);
            this.print(' ');
        }
    }

    protected void printTypedName(Type type, String string) {
        if (type != null) {
            this.printTypeLink(type);
        }
        if (string.length() > 0) {
            this.writer.space();
            this.writer.print(string);
        }
    }

    protected String makeSpace(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void printStaticAndType(boolean bl, Type type) {
        this.writer.printTypeSummaryHeader();
        if (bl) {
            this.print("static");
        }
        this.writer.space();
        if (type != null) {
            this.printTypeLink(type);
        }
        this.writer.printTypeSummaryFooter();
    }

    protected void printModifierAndType(ProgramElementDoc programElementDoc, Type type) {
        this.writer.printTypeSummaryHeader();
        this.printModifier(programElementDoc);
        if (type == null) {
            if (programElementDoc.isClass()) {
                this.print("class");
            } else {
                this.print("interface");
            }
        } else {
            this.printTypeLink(type);
        }
        this.writer.printTypeSummaryFooter();
    }

    protected void printModifier(ProgramElementDoc programElementDoc) {
        if (programElementDoc.isProtected()) {
            this.print("protected ");
        } else if (programElementDoc.isPrivate()) {
            this.print("private ");
        } else if (!programElementDoc.isPublic()) {
            this.writer.printText("doclet.Package_private");
            this.print(" ");
        }
        if (programElementDoc.isMethod() && ((MethodDoc)programElementDoc).isAbstract()) {
            this.print("abstract ");
        }
        if (programElementDoc.isStatic()) {
            this.print("static");
        }
        this.writer.space();
    }

    protected void printComment(ProgramElementDoc programElementDoc) {
        if (programElementDoc.inlineTags().length > 0) {
            this.writer.dd();
            this.writer.printInlineComment(programElementDoc);
        }
    }

    protected void printTags(ProgramElementDoc programElementDoc) {
        ConfigurationStandard configurationStandard = this.configuration();
        TagletManager tagletManager = configurationStandard.tagletManager;
        tagletManager.checkTags(programElementDoc, programElementDoc.tags(), false);
        tagletManager.checkTags(programElementDoc, programElementDoc.inlineTags(), true);
        Taglet[] tagletArray = programElementDoc instanceof FieldDoc ? this.configuration().tagletManager.getFieldCustomTags() : this.configuration().tagletManager.getMethodCustomTags();
        Tag[][] tagArrayArray = new Tag[tagletArray.length][];
        int n = 0;
        while (n < tagletArray.length) {
            tagArrayArray[n] = programElementDoc.tags(tagletArray[n].getName());
            ++n;
        }
        this.writer.dl();
        int n2 = 0;
        while (n2 < tagletArray.length) {
            String string = tagletArray[n2] instanceof SimpleTaglet ? ((SimpleTaglet)tagletArray[n2]).toString(tagArrayArray[n2], (HtmlStandardWriter)this.writer) : (tagletArray[n2] instanceof SeeTaglet ? ((SeeTaglet)tagletArray[n2]).toString(programElementDoc, this.writer) : tagletArray[n2].toString(tagArrayArray[n2]));
            if (string != null && string.length() > 0) {
                tagletManager.seenCustomTag(tagletArray[n2].getName());
                this.print(string);
            }
            ++n2;
        }
        this.writer.dlEnd();
    }

    protected String name(ProgramElementDoc programElementDoc) {
        return programElementDoc.name();
    }

    protected void printDeprecated(ProgramElementDoc programElementDoc) {
        Tag[] tagArray = programElementDoc.tags("deprecated");
        if (tagArray.length > 0) {
            this.writer.dd();
            this.writer.boldText("doclet.Deprecated");
            this.writer.space();
            this.writer.printInlineDeprecatedComment(programElementDoc, tagArray[0]);
            this.writer.p();
        } else {
            this.printDeprecatedClassComment(programElementDoc);
        }
    }

    protected void printDeprecatedClassComment(ProgramElementDoc programElementDoc) {
        Tag[] tagArray = programElementDoc.containingClass().tags("deprecated");
        if (tagArray.length > 0) {
            this.writer.dd();
            this.writer.boldText("doclet.Deprecated");
            this.writer.space();
        }
    }

    protected void printHead(MemberDoc memberDoc) {
        this.writer.h3();
        this.writer.print(memberDoc.name());
        this.writer.h3End();
    }

    protected void printFullComment(ProgramElementDoc programElementDoc) {
        if (this.configuration().nocomment) {
            return;
        }
        this.writer.dl();
        this.printDeprecated(programElementDoc);
        this.printCommentAndTags(programElementDoc);
        this.writer.dlEnd();
    }

    protected void printCommentAndTags(ProgramElementDoc programElementDoc) {
        this.printComment(programElementDoc);
        this.printTags(programElementDoc);
    }

    public void printSummaryHeader(ClassDoc classDoc) {
        this.printedSummaryHeader = true;
        this.writer.printSummaryHeader(this, classDoc);
    }

    public void printInheritedSummaryHeader(ClassDoc classDoc) {
        this.writer.printInheritedSummaryHeader(this, classDoc);
    }

    public void printInheritedSummaryFooter(ClassDoc classDoc) {
        this.writer.printInheritedSummaryFooter(this, classDoc);
    }

    public void printSummaryFooter(ClassDoc classDoc) {
        this.writer.printSummaryFooter(this, classDoc);
    }

    public void printSummaryMember(ClassDoc classDoc, ProgramElementDoc programElementDoc) {
        this.writer.printSummaryMember(this, classDoc, programElementDoc);
    }

    public void printInheritedSummaryMember(ClassDoc classDoc, ProgramElementDoc programElementDoc) {
        this.writer.printInheritedSummaryMember(this, classDoc, programElementDoc);
    }

    public void printMembersSummary() {
        ArrayList arrayList = new ArrayList(this.members(this.classdoc));
        if (arrayList.size() > 0) {
            this.printedSummaryHeader = true;
            this.printSummaryHeader(this.classdoc);
            Collections.sort(arrayList);
            int n = 0;
            while (n < arrayList.size()) {
                this.printSummaryMember(this.classdoc, (ProgramElementDoc)arrayList.get(n));
                ++n;
            }
            this.printSummaryFooter(this.classdoc);
        }
    }

    protected boolean isInherited(ProgramElementDoc programElementDoc) {
        if (programElementDoc.isPrivate() || programElementDoc.isPackagePrivate() && !programElementDoc.containingPackage().equals(this.classdoc.containingPackage())) {
            return false;
        }
        if (programElementDoc instanceof ClassDoc) {
            ClassDoc[] classDocArray = this.classdoc.innerClasses();
            int n = 0;
            while (n < classDocArray.length) {
                if (classDocArray[n].subclassOf((ClassDoc)programElementDoc)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public void printInheritedMembersSummary() {
        int n = 0;
        while (n < this.visibleClasses.size()) {
            ArrayList arrayList;
            ClassDoc classDoc = (ClassDoc)this.visibleClasses.get(n);
            if (classDoc != this.classdoc && (arrayList = new ArrayList(this.members(classDoc))).size() > 0) {
                if (!this.printedSummaryHeader && !(arrayList.get(0) instanceof MethodDoc)) {
                    this.printSummaryHeader(this.classdoc);
                    this.printSummaryFooter(this.classdoc);
                    this.printedSummaryHeader = true;
                }
                Collections.sort(arrayList);
                this.printInheritedSummaryHeader(classDoc);
                boolean bl = false;
                ProgramElementDoc programElementDoc = (ProgramElementDoc)arrayList.get(0);
                if (this.isInherited(programElementDoc)) {
                    this.printInheritedSummaryMember(classDoc, programElementDoc);
                    bl = true;
                }
                int n2 = 1;
                while (n2 < arrayList.size()) {
                    programElementDoc = (ProgramElementDoc)arrayList.get(n2);
                    if (this.isInherited(programElementDoc)) {
                        if (bl) {
                            this.print(", ");
                        }
                        this.printInheritedSummaryMember(classDoc, programElementDoc);
                        bl = true;
                    }
                    ++n2;
                }
                this.printInheritedSummaryFooter(classDoc);
            }
            ++n;
        }
    }

    public void printMembers() {
        List list = this.members(this.classdoc);
        if (list.size() > 0) {
            this.printHeader(this.classdoc);
            int n = 0;
            while (n < list.size()) {
                if (n > 0) {
                    this.writer.printMemberHeader();
                }
                this.writer.println("");
                this.printMember((ProgramElementDoc)list.get(n));
                this.writer.printMemberFooter();
                ++n;
            }
            this.printBodyHtmlEnd(this.classdoc);
        }
    }

    protected void printDeprecatedAPI(List list, String string) {
        if (list.size() > 0) {
            this.writer.tableIndexSummary();
            this.writer.tableHeaderStart("#CCCCFF");
            this.writer.boldText(string);
            this.writer.tableHeaderEnd();
            int n = 0;
            while (n < list.size()) {
                ProgramElementDoc programElementDoc = (ProgramElementDoc)list.get(n);
                ClassDoc classDoc = programElementDoc.containingClass();
                this.writer.trBgcolorStyle("white", "TableRowColor");
                this.writer.summaryRow(0);
                this.printDeprecatedLink(programElementDoc);
                this.writer.br();
                this.writer.printNbsps();
                this.writer.printInlineDeprecatedComment(programElementDoc, programElementDoc.tags("deprecated")[0]);
                this.writer.space();
                this.writer.summaryRowEnd();
                this.writer.trEnd();
                ++n;
            }
            this.writer.tableEnd();
            this.writer.space();
            this.writer.p();
        }
    }

    protected void printUseInfo(Object object, String string) {
        if (object == null) {
            return;
        }
        List list = (List)object;
        if (list.size() > 0) {
            this.writer.tableIndexSummary();
            this.writer.tableUseInfoHeaderStart("#CCCCFF");
            this.writer.print(string);
            this.writer.tableHeaderEnd();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ProgramElementDoc programElementDoc = (ProgramElementDoc)iterator.next();
                ClassDoc classDoc = programElementDoc.containingClass();
                this.writer.printSummaryLinkType(this, programElementDoc);
                if (classDoc != null && !(programElementDoc instanceof ConstructorDoc) && !(programElementDoc instanceof ClassDoc)) {
                    this.writer.bold(classDoc.name() + ".");
                }
                this.printSummaryLink(classDoc, programElementDoc);
                this.writer.printSummaryLinkComment(this, programElementDoc);
            }
            this.writer.tableEnd();
            this.writer.space();
            this.writer.p();
        }
    }

    protected void navSummaryLink() {
        List list = this.members(this.classdoc);
        if (list.size() > 0) {
            this.printNavSummaryLink(null, true);
            return;
        }
        ClassDoc classDoc = this.classdoc.superclass();
        while (classDoc != null) {
            List list2 = this.members(classDoc);
            if (list2.size() > 0) {
                this.printNavSummaryLink(classDoc, true);
                return;
            }
            classDoc = classDoc.superclass();
        }
        this.printNavSummaryLink(null, false);
    }

    protected void navDetailLink() {
        List list = this.visibleMemberMap.getMembersFor(this.classdoc);
        this.printNavDetailLink(list.size() > 0);
    }

    protected void serialWarning(SourcePosition sourcePosition, String string, String string2, String string3) {
        if (this.configuration().serialwarn) {
            this.msg().warning(sourcePosition, string, string2, string3);
        }
    }

    public void buildVisibleMemberMap() {
        this.visibleMemberMap = new VisibleMemberMap(this.classdoc, this.getMemberKind(), this.nodepr);
        this.visibleClasses = this.visibleMemberMap.getVisibleClassesList();
    }

    public ProgramElementDoc[] eligibleMembers(ProgramElementDoc[] programElementDocArray) {
        return this.nodepr ? Util.excludeDeprecatedMembers(programElementDocArray) : programElementDocArray;
    }

    public List members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public ConfigurationStandard configuration() {
        return this.writer.configuration;
    }

    public MessageRetriever msg() {
        return this.writer.msg(true);
    }
}

