/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.util;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.plugin.converter.ResourceHandler;
import sun.plugin.converter.util.NotDirectoryException;

public class CommandLine {
    private String[] commandLine;
    private boolean gui = false;
    private boolean params = false;
    private boolean help = false;
    private boolean processSubDirs = false;
    private boolean simulate = false;
    private boolean logFile = false;
    private boolean forceOverwrite = false;
    private String sourceStr;
    private String destStr;
    private String backupStr;
    private String templateStr;
    private String logPath;
    private String progressStr = "false";
    private Vector fileSpecs = new Vector();
    private boolean staticVersioning = true;
    private String sep = System.getProperty("file.separator");
    private String destPathSuffix = "_CONV";
    private String backupPathSuffix = "_BAK";
    private int maxFileCharLength = 27;

    public CommandLine(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.params = false;
        } else {
            this.params = true;
            this.commandLine = stringArray;
            this.readLine();
            if (this.fileSpecs.isEmpty()) {
                String string = ResourceHandler.getMessage("converter_gui.lablel2");
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
                while (stringTokenizer.hasMoreTokens()) {
                    this.fileSpecs.add(stringTokenizer.nextToken());
                }
            }
            this.checkForProblems();
        }
    }

    public void readLine() {
        try {
            int n = 0;
            while (n < this.commandLine.length) {
                String string = this.commandLine[n];
                String string2 = string.trim().toUpperCase();
                if (string2.startsWith("-")) {
                    if (this.isCmdLineOption(string2)) {
                        if (string2.equals("-GUI")) {
                            ++n;
                            this.gui = true;
                            --n;
                        } else if (string2.equals("-HELP")) {
                            ++n;
                            this.help = true;
                            --n;
                        } else if (string2.equals("-F")) {
                            this.forceOverwrite = true;
                        } else if (string2.equals("-SUBDIRS")) {
                            this.processSubDirs = true;
                        } else if (string2.equals("-SOURCE")) {
                            this.sourceStr = this.commandLine[++n];
                        } else if (string2.equals("-DEST")) {
                            this.destStr = this.commandLine[++n];
                        } else if (string2.equals("-BACKUP")) {
                            this.backupStr = this.commandLine[++n];
                        } else if (string2.equals("-TEMPLATE")) {
                            this.templateStr = this.commandLine[++n];
                        } else if (string2.equals("-LOG")) {
                            this.logFile = true;
                            this.logPath = this.commandLine[++n];
                        } else if (string2.equals("-PROGRESS")) {
                            this.progressStr = this.commandLine[++n];
                        } else if (string2.equals("-SIMULATE")) {
                            this.simulate = true;
                        } else if (string2.equals("-LATEST")) {
                            this.staticVersioning = false;
                        }
                    } else {
                        System.out.println(ResourceHandler.getMessage("plugin_converter.help_message"));
                        System.exit(0);
                    }
                } else {
                    this.fileSpecs.add(string);
                }
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.help = true;
        }
    }

    private void checkForProblems() {
        if (this.backupStr != null && this.destStr != null) {
            File file = new File(this.backupStr);
            File file2 = new File(this.destStr);
            if (file2.getAbsolutePath().equals(file.getAbsolutePath())) {
                System.out.println(ResourceHandler.getMessage("illegal_source_and_backup.info"));
                System.exit(0);
            }
        }
    }

    public boolean isLogFile() {
        return this.logFile;
    }

    public boolean areParams() {
        return this.params;
    }

    public boolean justHelp() {
        return this.help;
    }

    public boolean doSubDirs() {
        return this.processSubDirs;
    }

    public boolean doGUI() {
        return this.gui;
    }

    public boolean showProgress() {
        return this.progressStr.equals("true");
    }

    public boolean justSimulate() {
        return this.simulate;
    }

    public boolean isOverwrite() {
        return this.forceOverwrite;
    }

    public String getSourceDir() {
        if (this.sourceStr != null) {
            String string = this.doesExistAndAbsolute(this.sourceStr);
            return string;
        }
        return null;
    }

    public String getDestDir() {
        if (this.destStr != null) {
            String string = this.doesExistAndAbsolute(this.destStr);
            return string;
        }
        return null;
    }

    public String getBackupDir() {
        return this.backupStr;
    }

    public String getTemplateDir() {
        if (this.templateStr != null) {
            File file = new File(this.templateStr);
            String string = this.doesExistAndAbsolute(this.templateStr);
            return string;
        }
        return null;
    }

    public String getLogFile() {
        String string = null;
        if (this.logPath != null) {
            File file = new File(this.logPath);
            string = this.doesExistAndAbsolute(file.getParent()) + File.separator + file.getName();
        }
        return string;
    }

    public Vector getFileSpecs() {
        return this.fileSpecs;
    }

    public boolean getStaticVersioning() {
        return this.staticVersioning;
    }

    private boolean isCmdLineOption(String string) {
        String string2 = string.trim().toUpperCase();
        return string2.equals("-SOURCE") || string2.equals("-DEST") || string2.equals("-BACKUP") || string2.equals("-F") || string2.equals("-SUBDIRS") || string2.equals("-TEMPLATE") || string2.equals("-LOG") || string2.equals("-PROGRESS") || string2.equals("-GUI") || string2.equals("-HELP") || string2.equals("-SIMULATE") || string2.equals("-LATEST");
    }

    private String truncateString(String string, int n) {
        if (string.length() > n) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    private String doesExistAndAbsolute(String string) {
        File file = new File(string);
        try {
            if (file.exists()) {
                if (file.isAbsolute()) {
                    return string;
                }
                file = new File(System.getProperty("user.dir") + this.sep + string);
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                throw new NotDirectoryException(ResourceHandler.getMessage("caption.reldirnotfound") + ":  " + file.getAbsolutePath());
            }
            throw new NotDirectoryException(ResourceHandler.getMessage("caption.absdirnotfound") + ":  " + file.getAbsolutePath());
        }
        catch (NotDirectoryException notDirectoryException) {
            System.out.println(notDirectoryException.getMessage());
            System.exit(0);
            return null;
        }
    }
}

