/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import sun.plugin.converter.ResourceHandler;
import sun.plugin.converter.engine.ConvertSet;
import sun.plugin.converter.engine.DefaultSet;
import sun.plugin.converter.engine.PluginConverter;
import sun.plugin.converter.gui.ProgressGUI;
import sun.plugin.converter.gui.TemplateFileChoice;
import sun.plugin.converter.util.AdvancedDialog;
import sun.plugin.converter.util.FlexFilter;
import sun.plugin.converter.util.HelpDialog;
import sun.plugin.converter.util.NotDirectoryException;
import sun.plugin.converter.util.NotFileException;

public class ConverterGUI
extends JFrame
implements ActionListener,
ItemListener {
    private JButton dirBttn;
    private JButton backupBttn;
    private JButton runBttn;
    private JButton invisibleBttn;
    private JRadioButton staticVersioningRadioButton;
    private JRadioButton dynamicVersioningRadioButton;
    private JCheckBox recursiveCheckBox;
    private JTextField dirTF;
    private JTextField matchingTF;
    private JTextField backupTF;
    private JPanel staticVersioningPanel = new JPanel();
    private JPanel dynamicVersioningPanel = new JPanel();
    private JTextArea staticVersioningTextArea;
    private JTextArea dynamicVersioningTextArea;
    private TemplateFileChoice templateCh;
    private JLabel dirLabel;
    private JLabel matchingLabel;
    private JLabel backupLabel;
    private JLabel templateLabel;
    private JLabel staticVersioningLabel;
    private JMenuItem exitMenuItem;
    private JMenuItem optionMenuItem;
    private JMenuItem helpMenuItem;
    private JMenuItem aboutMenuItem;
    private JSeparator sep1 = new JSeparator();
    private JSeparator sep2 = new JSeparator();
    private JSeparator sep3 = new JSeparator();
    private static Image bgImage;
    private static Image dukeImage;
    private String[] descriptors;
    private String defaultDirBackupPath;
    private String defaultOneFileBackupPath;
    private boolean firstTime = true;
    private static PluginConverter converter;
    private ConvertSet convertSet;
    static /* synthetic */ Class class$sun$plugin$converter$gui$ConverterGUI;

    public ConverterGUI() {
        super(ResourceHandler.getMessage("product_name"));
        try {
            converter = new PluginConverter();
            converter.setShowProgressStdOut(false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showNoTemplateDialog();
        }
        this.convertSet = new DefaultSet();
        converter.setConvertSet(this.convertSet);
        this.setResizable(false);
        this.setIconImage(dukeImage);
        this.majorLayout();
        this.setup();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Dimension dimension = this.getToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        }
        super.setVisible(bl);
    }

    public void majorLayout() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(ResourceHandler.getMessage("menu.file"));
        this.exitMenuItem = new JMenuItem(ResourceHandler.getMessage("menu.exit"));
        jMenu.add(this.exitMenuItem);
        this.exitMenuItem.addActionListener(this);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(ResourceHandler.getMessage("menu.edit"));
        this.optionMenuItem = new JMenuItem(ResourceHandler.getMessage("menu.option"));
        jMenu2.add(this.optionMenuItem);
        this.optionMenuItem.addActionListener(this);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(ResourceHandler.getMessage("menu.help"));
        this.helpMenuItem = new JMenuItem(ResourceHandler.getMessage("menu.help"));
        jMenu3.add(this.helpMenuItem);
        jMenu3.add(new JSeparator());
        this.aboutMenuItem = new JMenuItem(ResourceHandler.getMessage("menu.about"));
        jMenu3.add(this.aboutMenuItem);
        this.helpMenuItem.addActionListener(this);
        this.aboutMenuItem.addActionListener(this);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        this.dirLabel = new JLabel(ResourceHandler.getMessage("converter_gui.lablel0"));
        this.dirTF = new JTextField();
        this.dirBttn = new JButton(ResourceHandler.getMessage("button.browse"));
        this.matchingLabel = new JLabel(ResourceHandler.getMessage("converter_gui.lablel1"));
        this.matchingTF = new JTextField(ResourceHandler.getMessage("converter_gui.lablel2"));
        this.recursiveCheckBox = new JCheckBox(ResourceHandler.getMessage("converter_gui.lablel3"));
        this.backupLabel = new JLabel(ResourceHandler.getMessage("converter_gui.lablel5"));
        this.backupTF = new JTextField();
        this.backupBttn = new JButton(ResourceHandler.getMessage("button.browse"));
        this.templateLabel = new JLabel(ResourceHandler.getMessage("converter_gui.lablel7"));
        this.templateCh = new TemplateFileChoice();
        this.staticVersioningLabel = new JLabel(ResourceHandler.getMessage("static.versioning.label"));
        String string = System.getProperty("java.version");
        if (string.indexOf("-") > 0) {
            string = string.substring(0, string.indexOf("-"));
        }
        int n = string.indexOf(".");
        n = string.indexOf(".", n + 1);
        String string2 = string.substring(0, n);
        this.staticVersioningRadioButton = new JRadioButton(ResourceHandler.getMessage("static.versioning.radio.button") + string);
        this.dynamicVersioningRadioButton = new JRadioButton(ResourceHandler.getMessage("dynamic.versioning.radio.button1") + string2 + ResourceHandler.getMessage("dynamic.versioning.radio.button2"));
        this.staticVersioningTextArea = new JTextArea(ResourceHandler.getMessage("static.versioning.text"));
        this.dynamicVersioningTextArea = new JTextArea(ResourceHandler.getMessage("dynamic.versioning.text1") + string2 + ResourceHandler.getMessage("dynamic.versioning.text2"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.staticVersioningRadioButton);
        buttonGroup.add(this.dynamicVersioningRadioButton);
        this.runBttn = new JButton(ResourceHandler.getMessage("button.convert"));
        this.recursiveCheckBox.setOpaque(false);
        this.staticVersioningRadioButton.setOpaque(false);
        this.dynamicVersioningRadioButton.setOpaque(false);
        this.staticVersioningTextArea.setEditable(false);
        this.staticVersioningTextArea.setLineWrap(true);
        this.staticVersioningTextArea.setWrapStyleWord(true);
        this.dynamicVersioningTextArea.setEditable(false);
        this.dynamicVersioningTextArea.setLineWrap(true);
        this.dynamicVersioningTextArea.setWrapStyleWord(true);
        this.staticVersioningPanel.setLayout(new BorderLayout());
        this.staticVersioningPanel.add((Component)this.staticVersioningTextArea, "Center");
        this.staticVersioningPanel.setBorder(new LineBorder(Color.black));
        this.dynamicVersioningPanel.setLayout(new BorderLayout());
        this.dynamicVersioningPanel.add((Component)this.dynamicVersioningTextArea, "Center");
        this.dynamicVersioningPanel.setBorder(new LineBorder(Color.black));
        if (converter.isStaticVersioning()) {
            this.staticVersioningRadioButton.setSelected(true);
        } else {
            this.dynamicVersioningRadioButton.setSelected(true);
        }
        this.addListeners();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(gridBagLayout2);
        gridBagLayout2.setConstraints(this.dirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.dirTF, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.dirBttn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.matchingLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.matchingTF, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.recursiveCheckBox, new GridBagConstraints(0, 4, 0, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.backupLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.backupTF, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.backupBttn, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.templateLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.templateCh, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.sep1, new GridBagConstraints(0, 9, 0, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        gridBagLayout2.setConstraints(this.staticVersioningLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.staticVersioningRadioButton, new GridBagConstraints(0, 11, 0, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.staticVersioningPanel, new GridBagConstraints(0, 12, 0, 1, 0.0, 0.0, 17, 1, new Insets(5, 25, 10, 0), 0, 0));
        gridBagLayout2.setConstraints(this.dynamicVersioningRadioButton, new GridBagConstraints(0, 13, 0, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.dynamicVersioningPanel, new GridBagConstraints(0, 14, 0, 1, 0.0, 0.0, 17, 1, new Insets(5, 25, 0, 0), 0, 0));
        gridBagLayout2.setConstraints(this.sep2, new GridBagConstraints(0, 15, 0, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.invisibleBttn = new JButton();
        this.invisibleBttn.setVisible(false);
        gridBagLayout2.setConstraints(this.invisibleBttn, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 10, new Insets(20, 10, 0, 0), 0, 0));
        jPanel.add(this.dirLabel);
        jPanel.add(this.dirTF);
        jPanel.add(this.dirBttn);
        jPanel.add(this.matchingLabel);
        jPanel.add(this.matchingTF);
        jPanel.add(this.recursiveCheckBox);
        jPanel.add(this.backupLabel);
        jPanel.add(this.backupTF);
        jPanel.add(this.backupBttn);
        jPanel.add(this.templateLabel);
        jPanel.add(this.templateCh);
        jPanel.add(this.sep1);
        jPanel.add(this.staticVersioningLabel);
        jPanel.add(this.staticVersioningRadioButton);
        jPanel.add(this.staticVersioningPanel);
        jPanel.add(this.dynamicVersioningRadioButton);
        jPanel.add(this.dynamicVersioningPanel);
        jPanel.add(this.sep2);
        jPanel.add(this.invisibleBttn);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(gridBagLayout3);
        gridBagLayout3.setConstraints(this.runBttn, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        jPanel2.add(this.runBttn);
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        JPanel jPanel3 = new JPanel(){

            public void paint(Graphics graphics) {
                Dimension dimension = this.getSize();
                graphics.drawImage(bgImage, 0, 0, dimension.width, dimension.height, 0, 0, bgImage.getWidth(this), bgImage.getHeight(this), this);
                super.paint(graphics);
            }
        };
        jPanel3.setOpaque(false);
        jPanel3.setLayout(gridBagLayout4);
        gridBagLayout4.setConstraints(jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 0, 10), 0, 0));
        gridBagLayout4.setConstraints(jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 2, new Insets(0, 10, 10, 10), 0, 0));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        Border border = BorderFactory.createEtchedBorder();
        jPanel3.setBorder(border);
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout5);
        gridBagLayout5.setConstraints(jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add(jPanel3);
        this.pack();
    }

    public void setup() {
        if (this.firstTime) {
            this.defaultDirBackupPath = this.convertSet.getBackupPath().getPath();
            this.defaultOneFileBackupPath = System.getProperty("user.dir");
            this.firstTime = false;
        }
        this.dirTF.setText(this.convertSet.getSourcePath().getPath());
        this.recursiveCheckBox.setSelected(converter.isRecurse());
        if (converter.isStaticVersioning()) {
            this.staticVersioningRadioButton.setSelected(true);
        } else {
            this.dynamicVersioningRadioButton.setSelected(true);
        }
        this.backupTF.setText(this.defaultDirBackupPath);
    }

    private void resetDefaults() {
        this.firstTime = true;
        this.setup();
    }

    private void addListeners() {
        this.dirBttn.addActionListener(this);
        this.backupBttn.addActionListener(this);
        this.runBttn.addActionListener(this);
        this.recursiveCheckBox.addItemListener(this);
        this.templateCh.addItemListener(this);
        this.dirTF.addActionListener(this);
        this.staticVersioningRadioButton.addItemListener(this);
        this.dynamicVersioningRadioButton.addItemListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConverterGUI.this.quit();
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component = (Component)actionEvent.getSource();
        if (component == this.dirBttn) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(2);
            try {
                jFileChooser.setCurrentDirectory(new File(this.dirTF.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                this.dirTF.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                if (!jFileChooser.getSelectedFile().isDirectory()) {
                    this.backupTF.setText(jFileChooser.getSelectedFile().getParentFile().getAbsolutePath() + "_BAK");
                } else {
                    this.backupTF.setText(jFileChooser.getSelectedFile().getAbsolutePath() + "_BAK");
                }
            }
        } else if (component == this.backupBttn) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            try {
                jFileChooser.setCurrentDirectory(new File(this.backupTF.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                this.backupTF.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        } else if (component == this.optionMenuItem) {
            this.showOptionDialog();
        } else if (component == this.helpMenuItem) {
            this.showHelpDialog();
        } else if (component == this.runBttn) {
            boolean bl = true;
            bl = this.setDirectory();
            if (bl && !this.testSourceVsBackup()) {
                this.convertSet.setBackupPath(new File(this.backupTF.getText()));
                boolean bl2 = bl = this.setTemplateFile((String)this.templateCh.getSelectedItem()) && bl;
                if (bl) {
                    new ProgressGUI(converter).setVisible(true);
                }
            }
        } else if (component == this.exitMenuItem) {
            this.quit();
        } else if (component == this.aboutMenuItem) {
            this.showAboutDialog();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Component component = (Component)itemEvent.getSource();
        if (component == this.recursiveCheckBox) {
            converter.setRecurse(this.recursiveCheckBox.isSelected());
        } else if (component == this.staticVersioningRadioButton || component == this.dynamicVersioningRadioButton) {
            converter.setStaticVersioning(this.staticVersioningRadioButton.isSelected());
        } else if (component == this.templateCh && itemEvent.getStateChange() == 1) {
            String string = (String)this.templateCh.getSelectedItem();
            if (string.equals(TemplateFileChoice.OTHER_STR)) {
                String string2 = null;
                FileDialog fileDialog = new FileDialog((Frame)this, "Select File", 0);
                fileDialog.show();
                if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
                    string2 = fileDialog.getDirectory() + fileDialog.getFile();
                }
                if (string2 != null && this.setTemplateFile(string2)) {
                    if (!this.templateCh.testIfInList(string2)) {
                        this.templateCh.addItem(string2);
                    }
                    this.templateCh.select(string2);
                } else {
                    this.templateCh.select(this.templateCh.getPreviousSelection());
                }
                fileDialog.dispose();
            } else {
                this.templateCh.select(string);
            }
        }
    }

    private boolean testSourceVsBackup() {
        if (this.dirTF.getText().equals(this.backupTF.getText())) {
            String string = ResourceHandler.getMessage("caption.warning");
            String string2 = ResourceHandler.getMessage("warning_dialog.info") + this.backupTF.getText() + "_BAK";
            int n = JOptionPane.showConfirmDialog(this, string2, string, 2);
            if (n == 0) {
                this.backupTF.setText(this.backupTF.getText() + "_BAK");
                return false;
            }
            if (n == 1) {
                return true;
            }
        }
        return false;
    }

    private boolean setDirectory() {
        String string = this.dirTF.getText().trim();
        if (string.equals("")) {
            string = System.getProperty("user.dir");
        }
        try {
            File file = new File(string);
            if (!file.isDirectory()) {
                if (!file.exists()) {
                    if (this.recursiveCheckBox.isSelected()) {
                        throw new NotDirectoryException(file.getAbsolutePath());
                    }
                    throw new NotFileException(file.getAbsolutePath());
                }
                this.convertSet.setFile(file);
                this.convertSet.setDestinationPath(file.getParentFile());
            } else {
                this.setMatchingFileNames();
                FlexFilter flexFilter = new FlexFilter();
                flexFilter.addDescriptors(this.descriptors);
                flexFilter.setFilesOnly(!this.recursiveCheckBox.isSelected());
                this.convertSet.setSourcePath(file, flexFilter);
                this.convertSet.setDestinationPath(file);
            }
        }
        catch (NotDirectoryException notDirectoryException) {
            String string2 = ResourceHandler.getMessage("notdirectory_dialog.caption1");
            String string3 = ResourceHandler.getMessage("notdirectory_dialog.info0") + (string.equals("") ? ResourceHandler.getMessage("notdirectory_dialog.info5") : string);
            JOptionPane.showMessageDialog(this, string3, string2, 0);
            return false;
        }
        catch (NotFileException notFileException) {
            String string4 = ResourceHandler.getMessage("notdirectory_dialog.caption0");
            String string5 = ResourceHandler.getMessage("notdirectory_dialog.info1") + string;
            JOptionPane.showMessageDialog(this, string5, string4, 0);
            return false;
        }
        return true;
    }

    private boolean setTemplateFile(String string) {
        File file = new File(this.templateCh.getSelectedPath(string));
        if (!file.getName().toLowerCase().endsWith(".tpl")) {
            String string2 = ResourceHandler.getMessage("nottemplatefile_dialog.caption");
            String string3 = ResourceHandler.getMessage("nottemplatefile_dialog.info0");
            String string4 = PluginConverter.getDefaultTemplateFileName();
            String string5 = string2 + System.getProperty("line.separator") + file.getName();
            JOptionPane.showMessageDialog(this, string5, null, 0);
            this.templateCh.select(this.templateCh.getPreviousSelection());
            return false;
        }
        try {
            converter.setTemplateFilePath(this.templateCh.getSelectedPath(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = ((String)this.templateCh.getSelectedItem()).trim();
            String string6 = ResourceHandler.getMessage("notdirectory_dialog.caption0");
            String string7 = ResourceHandler.getMessage("notdirectory_dialog.info1") + ResourceHandler.getMessage("notdirectory_dialog.info4") + (string.equals("") ? ResourceHandler.getMessage("notdirectory_dialog.info5") : string);
            return false;
        }
        return true;
    }

    private void setMatchingFileNames() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.matchingTF.getText(), ",");
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            this.descriptors = new String[1];
            this.descriptors[0] = "*";
            return;
        }
        this.descriptors = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            this.descriptors[n2++] = stringTokenizer.nextToken().trim();
        }
    }

    public static PluginConverter getPluginConverter() {
        return converter;
    }

    protected void quit() {
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    private void showNoTemplateDialog() {
        String string = ResourceHandler.getMessage("notemplate_dialog.caption");
        String string2 = ResourceHandler.getMessage("notemplate_dialog.info0") + PluginConverter.getDefaultTemplateFileName() + ResourceHandler.getMessage("notemplate_dialog.info1");
        JOptionPane.showMessageDialog(this, string2, string, 0);
        System.exit(0);
    }

    private void showAboutDialog() {
        String string = ResourceHandler.getMessage("about_dialog.caption");
        String string2 = System.getProperty("java.version");
        String string3 = ResourceHandler.getMessage("about_dialog.info") + string2 + ResourceHandler.getMessage("about_dialog.info2");
        JOptionPane.showMessageDialog(this, string3, string, 1);
    }

    private void showHelpDialog() {
        HelpDialog helpDialog = new HelpDialog((Frame)this, false);
        helpDialog.setVisible(true);
    }

    private void showOptionDialog() {
        AdvancedDialog advancedDialog = new AdvancedDialog((Frame)this, false, converter);
        advancedDialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        new ConverterGUI().setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            InputStream inputStream = (class$sun$plugin$converter$gui$ConverterGUI == null ? (class$sun$plugin$converter$gui$ConverterGUI = ConverterGUI.class$("sun.plugin.converter.gui.ConverterGUI")) : class$sun$plugin$converter$gui$ConverterGUI).getClassLoader().getResourceAsStream("images/background.gif");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[2048];
            int n = 0;
            while ((n = inputStream.read(byArray, 0, 2048)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            bgImage = new ImageIcon(byteArrayOutputStream.toByteArray()).getImage();
            byteArrayOutputStream.close();
            inputStream.close();
            inputStream = (class$sun$plugin$converter$gui$ConverterGUI == null ? (class$sun$plugin$converter$gui$ConverterGUI = ConverterGUI.class$("sun.plugin.converter.gui.ConverterGUI")) : class$sun$plugin$converter$gui$ConverterGUI).getClassLoader().getResourceAsStream("images/duke.gif");
            byteArrayOutputStream = new ByteArrayOutputStream();
            n = 0;
            while ((n = inputStream.read(byArray, 0, 2048)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            dukeImage = new ImageIcon(byteArrayOutputStream.toByteArray()).getImage();
            byteArrayOutputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

